/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.WebTestDescription;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.testcase.TestCaseKit;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class JUnit3WebTestDescription
implements WebTestDescription {
    public static Function<Test, WebTestDescription> TRANSFORMER = new Function<Test, WebTestDescription>(){

        public WebTestDescription apply(@Nullable Test input) {
            return new JUnit3WebTestDescription(input);
        }
    };
    private final Test test;
    private final Iterable<WebTestDescription> children;

    public JUnit3WebTestDescription(Test test) {
        this.test = Assertions.notNull(test);
        this.children = this.collectChildren();
    }

    private Iterable<WebTestDescription> collectChildren() {
        if (this.isTest()) {
            return Collections.emptyList();
        }
        Preconditions.checkState((boolean)TestSuite.class.isInstance(this.test), (Object)("Unknown JUnit3 suite: " + this.test));
        return Iterables.transform(this.getTests(), TRANSFORMER);
    }

    private Iterable<Test> getTests() {
        return ImmutableList.copyOf((Iterator)Iterators.forEnumeration((Enumeration)((TestSuite)this.test).tests()));
    }

    @Override
    public String name() {
        return TestCaseKit.getFullName(this.test);
    }

    @Override
    public String className() {
        return this.test.getClass().getName();
    }

    @Override
    public String methodName() {
        if (this.test instanceof TestCase) {
            return ((TestCase)this.test).getName();
        }
        return null;
    }

    @Override
    public Class<?> testClass() {
        return this.test.getClass();
    }

    @Override
    public Iterable<Annotation> annotations() {
        return Arrays.asList(this.testClass().getAnnotations());
    }

    @Override
    public Set<Category> categories() {
        WebTest webTest = this.testClass().getAnnotation(WebTest.class);
        return Category.fromAnnotation(webTest);
    }

    @Override
    public boolean isTest() {
        return this.test instanceof TestCase;
    }

    @Override
    public boolean isSuite() {
        return !this.isTest();
    }

    @Override
    public int testCount() {
        return this.test.countTestCases();
    }

    @Override
    public Iterable<WebTestDescription> children() {
        return ImmutableList.copyOf(this.children);
    }

    public boolean equals(Object obj) {
        if (!JUnit3WebTestDescription.class.isInstance(obj)) {
            return false;
        }
        JUnit3WebTestDescription that = (JUnit3WebTestDescription)obj;
        return this.test.equals(that.test);
    }

    public int hashCode() {
        return this.test.hashCode();
    }
}

