/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.meterware.httpunit.WebClient;
import com.meterware.httpunit.WebClientListener;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class FuncTestWebClientListener
implements WebClientListener {
    private static final int MAX_PREV_PAGES_KEPT = 5;
    private static final String REQUEST_START_TIME = "request.start.time";
    long requestCount = 0L;
    long requestTime = 0L;
    long parseCount = 0L;
    long parseTimeNanos = 0L;
    List<Long> requestTimeList = new ArrayList<Long>(100);
    final LifoList<String> previousPages = new LifoList(5);

    public void requestSent(WebClient src, WebRequest req) {
        ++this.requestCount;
        src.setAttribute(REQUEST_START_TIME, (Object)new Date());
    }

    public void responseReceived(WebClient src, WebResponse resp) {
        Date then = (Date)src.getAttribute(REQUEST_START_TIME);
        if (then != null) {
            src.setAttribute(REQUEST_START_TIME, null);
            long timeMS = new Date().getTime() - then.getTime();
            this.requestTime += timeMS;
            this.requestTimeList.add(timeMS);
        }
        this.squirrelAwayTheResponse(resp);
    }

    public void responseParsed(WebClient src, WebResponse resp, long parseNanos) {
        if (this.parseCount == 0L) {
            this.parseTimeNanos = src.getParseTimeNanos();
            this.parseCount = src.getParseCount();
        }
        this.parseTimeNanos += parseNanos;
        ++this.parseCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void squirrelAwayTheResponse(WebResponse resp) {
        if (!this.isError(resp)) {
            try {
                LifoList<String> lifoList = this.previousPages;
                synchronized (lifoList) {
                    this.previousPages.offer(resp.getText());
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read the web response text");
            }
        }
    }

    private boolean isError(WebResponse resp) {
        return resp.getResponseCode() >= 400;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getLastResponses() {
        ArrayList<String> list = new ArrayList<String>();
        LifoList<String> lifoList = this.previousPages;
        synchronized (lifoList) {
            for (String previousPage : this.previousPages) {
                list.add(previousPage);
            }
        }
        return list;
    }

    public long getRequestCount() {
        return this.requestCount;
    }

    public long getRequestTime() {
        return this.requestTime;
    }

    public long getParseCount() {
        return this.parseCount;
    }

    public long getParseTimeNanos() {
        return this.parseTimeNanos;
    }

    public long getPercentileRequestTime(int percentile) {
        if (this.requestTimeList.size() == 0) {
            return -1L;
        }
        Collections.sort(this.requestTimeList);
        if (percentile == 100) {
            return this.requestTimeList.get(this.requestTimeList.size() - 1);
        }
        int actualPercentile = Math.max(0, Math.min(100, percentile));
        int size = this.requestTimeList.size();
        double dPercentile = (double)size * (double)actualPercentile / 100.0;
        int index = Math.max(0, Math.min(size, (int)dPercentile));
        return this.requestTimeList.get(index);
    }

    private static class LifoList<E>
    implements Iterable<E> {
        private LinkedList<E> linkList = new LinkedList();
        private final int size;

        private LifoList(int size) {
            this.size = size;
            this.linkList = new LinkedList();
        }

        public void offer(E element) {
            if (this.linkList.size() >= this.size) {
                this.linkList.removeLast();
            }
            this.linkList.addFirst(element);
        }

        @Override
        public Iterator<E> iterator() {
            return this.linkList.iterator();
        }
    }
}

