/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.DefaultFuncTestHttpUnitOptions;
import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.FuncTestCaseJiraSetup;
import com.atlassian.jira.functest.framework.FuncTestHelperFactory;
import com.atlassian.jira.functest.framework.FuncTestWebClientListener;
import com.atlassian.jira.functest.framework.FunctTestConstants;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.Parser;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.assertions.IssueTableAssertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.backdoor.Backdoor;
import com.atlassian.jira.functest.framework.backdoor.PluginIndexConfigurationControl;
import com.atlassian.jira.functest.framework.dump.TestCaseDumpKit;
import com.atlassian.jira.functest.framework.dump.TestInformationKit;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.log.LogOnBothSides;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.internal.async.AsynchronousJiraRestClientFactory;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.log.FuncTestLoggerImpl;
import com.atlassian.jira.util.IndexDocumentConfigurationControlUtil;
import com.atlassian.jira.util.ProgressPageControl;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.atlassian.jira.webtests.WebTesterFactory;
import com.atlassian.jira.webtests.util.EnvironmentAware;
import com.atlassian.jira.webtests.util.LocalTestEnvironmentData;
import java.net.URISyntaxException;
import java.util.Date;
import junit.framework.TestCase;
import net.sourceforge.jwebunit.WebTester;

public class FuncTestCase
extends TestCase
implements EnvironmentAware,
FuncTestLogger,
FunctTestConstants {
    private FuncTestCaseJiraSetup jiraTestJiraSetup;
    private FuncTestLoggerImpl logger = new FuncTestLoggerImpl(1);
    protected WebTester tester;
    protected com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData;
    protected Navigation navigation;
    protected Form form;
    protected HtmlPage page;
    protected Parser parse;
    protected Administration administration;
    protected Backdoor backdoor;
    protected Assertions assertions;
    protected TextAssertions text;
    protected IssueTableAssertions issueTableAssertions;
    protected FuncTestLogger log;
    protected LocatorFactory locator;
    protected JIRAWebTest oldway_consider_porting;
    protected FuncTestHelperFactory funcTestHelperFactory;
    private FuncTestWebClientListener webClientListener;
    private long startTime;

    public static String builtInCustomFieldKey(String type) {
        return "com.atlassian.jira.plugin.system.customfieldtypes:" + type;
    }

    protected void setUpTest() {
    }

    protected void setUpHttpUnitOptions() {
    }

    protected final void setUp() {
        DefaultFuncTestHttpUnitOptions.setDefaultOptions();
        this.setUpHttpUnitOptions();
        com.atlassian.jira.webtests.util.JIRAEnvironmentData envData = this.getEnvironmentData();
        this.webClientListener = new FuncTestWebClientListener();
        try {
            this.funcTestHelperFactory = new FuncTestHelperFactory(this, envData, this.webClientListener, this.shouldSkipSetup());
        }
        catch (Throwable throwable) {
            WebTester tester = WebTesterFactory.createNewWebTester(envData);
            tester.beginAt("/");
            this.dumpFailureInformation(throwable, this, tester);
            throw new RuntimeException("Unable to setup JIRA", throwable);
        }
        try {
            this.tester = this.funcTestHelperFactory.getTester();
            this.navigation = this.funcTestHelperFactory.getNavigation();
            this.form = this.funcTestHelperFactory.getForm();
            this.page = new HtmlPage(this.tester);
            this.administration = this.funcTestHelperFactory.getAdministration();
            this.backdoor = this.funcTestHelperFactory.getBackdoor();
            this.assertions = this.funcTestHelperFactory.getAssertions();
            this.text = this.funcTestHelperFactory.getTextAssertions();
            this.issueTableAssertions = this.funcTestHelperFactory.getIssueTableAssertions();
            this.parse = this.funcTestHelperFactory.getParser();
            this.log = new FuncTestLoggerImpl(3);
            this.locator = this.funcTestHelperFactory.getLocator();
            this.jiraTestJiraSetup = this.funcTestHelperFactory.getFuncTestCaseJiraSetup();
            class ConcreteJIRAWebTest
            extends JIRAWebTest {
                public ConcreteJIRAWebTest(String name, WebTester tester, com.atlassian.jira.webtests.util.JIRAEnvironmentData envirData) {
                    super(name, envirData);
                    this.tester = tester;
                }
            }
            this.oldway_consider_porting = new ConcreteJIRAWebTest(this.getName(), this.tester, envData);
            try {
                if (this.backdoor.dataImport().isSetUp()) {
                    this.backdoor.darkFeatures().enableForSite("jira.onboarding.feature.disabled");
                }
            }
            catch (Exception e) {
                this.log("failed to disable onboarding ");
                this.log(e);
            }
            this.setUpTest();
        }
        catch (Throwable throwable) {
            this.dumpFailureInformation(throwable, this);
            throw new RuntimeException("Unable to setup the TestCase itself", throwable);
        }
    }

    protected boolean shouldSkipSetup() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void tearDown() {
        try {
            this.tearDownTest();
        }
        finally {
            this.jiraTestJiraSetup.tearDown(this);
        }
    }

    protected void tearDownTest() {
    }

    public com.atlassian.jira.webtests.util.JIRAEnvironmentData getEnvironmentData() {
        if (this.environmentData == null) {
            this.environmentData = new LocalTestEnvironmentData();
        }
        return this.environmentData;
    }

    @Override
    public void setEnvironmentData(com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData) {
        this.environmentData = environmentData;
    }

    public WebTester getTester() {
        return this.tester;
    }

    public Assertions getAssertions() {
        return this.assertions;
    }

    public FuncTestWebClientListener getWebClientListener() {
        return this.webClientListener;
    }

    public void log(Object logData) {
        this.logger.log(logData);
    }

    public void log(Throwable t) {
        this.logger.log(t);
    }

    protected XPathLocator xpath(String xpathExpression) {
        return this.locator.xpath(xpathExpression);
    }

    protected void runTest() throws Throwable {
        try {
            super.runTest();
        }
        catch (Throwable throwable) {
            this.dumpFailureInformation(throwable, this);
            throw throwable;
        }
    }

    private void dumpFailureInformation(Throwable throwable, TestCase testCase) {
        try {
            TestCaseDumpKit.dumpTestInformation(testCase, new Date(), throwable, this.isDumpHTML());
        }
        catch (RuntimeException ignored) {
            ignored.printStackTrace();
        }
    }

    private void dumpFailureInformation(Throwable throwable, TestCase testCase, WebTester tester) {
        try {
            TestCaseDumpKit.dumpTestInformation(testCase, new Date(), throwable, this.isDumpHTML(), tester);
        }
        catch (RuntimeException ignored) {
            ignored.printStackTrace();
        }
    }

    protected boolean isDumpHTML() {
        return true;
    }

    public void runBare() throws Throwable {
        this.startTime = System.currentTimeMillis();
        com.atlassian.jira.webtests.util.JIRAEnvironmentData data = this.getEnvironmentData();
        com.atlassian.jira.testkit.client.Backdoor testkit = new com.atlassian.jira.testkit.client.Backdoor((JIRAEnvironmentData)data);
        LogOnBothSides.log(testkit, TestInformationKit.getStartMsg(this, data.getTenant()));
        try {
            super.runBare();
            LogOnBothSides.log(testkit, TestInformationKit.getEndMsg((TestCase)this, data.getTenant(), System.currentTimeMillis() - this.startTime, this.webClientListener));
        }
        catch (Throwable throwable) {
            LogOnBothSides.log(testkit, TestInformationKit.getEndMsg(this, data.getTenant(), System.currentTimeMillis() - this.startTime, this.webClientListener, throwable));
            throw throwable;
        }
        finally {
            this.clearTestCaseVariables();
        }
    }

    private void clearTestCaseVariables() {
        this.tester = null;
        this.funcTestHelperFactory = null;
        this.environmentData = null;
        this.navigation = null;
        this.form = null;
        this.page = null;
        this.parse = null;
        this.administration = null;
        this.backdoor = null;
        this.assertions = null;
        this.jiraTestJiraSetup = null;
        this.text = null;
        this.log = null;
        this.oldway_consider_porting = null;
        this.webClientListener = null;
        this.locator = null;
    }

    protected JiraRestClient createRestClient(String user, String password) {
        AsynchronousJiraRestClientFactory restClientFactory = new AsynchronousJiraRestClientFactory();
        try {
            return restClientFactory.createWithBasicHttpAuthentication(this.getEnvironmentData().getBaseUrl().toURI(), user, password);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected JiraRestClient createRestClient() {
        return this.createRestClient("admin", "admin");
    }

    public void waitAndReloadBulkOperationProgressPage() {
        this.waitAndReloadBulkOperationProgressPage(this.tester);
    }

    public void waitForOperationProgressPage(WebTester webTester) {
        webTester.assertTextPresent("Bulk Operation Progress");
        ProgressPageControl.wait(webTester, "bulkoperationprogressform", "Refresh");
        this.log("waitForOperationProgressPage");
    }

    public void waitAndReloadBulkOperationProgressPage(WebTester webTester) {
        webTester.assertTextPresent("Bulk Operation Progress");
        ProgressPageControl.waitAndReload(webTester, "bulkoperationprogressform", "Refresh", "Acknowledge");
        this.log("waitAndReloadBulkOperationProgressPage");
    }

    public void updatePluginIndexConfiguration(String pluginKey, String filename, PluginIndexConfigurationControl pluginIndexConfigurationControl) {
        this.administration.plugins().referencePlugin().disable();
        IndexDocumentConfigurationControlUtil.loadPropertyFromFile(pluginKey, filename, pluginIndexConfigurationControl);
        this.administration.plugins().referencePlugin().enable();
    }
}

