/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.WebTestDescription;
import com.atlassian.jira.functest.framework.WebTestListener;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.google.common.base.Function;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeSuiteListener
implements WebTestListener {
    private static final Logger log = LoggerFactory.getLogger(CompositeSuiteListener.class);
    private final Collection<WebTestListener> listeners;

    private CompositeSuiteListener(Collection<WebTestListener> listeners) {
        this.listeners = listeners;
    }

    @Override
    public void suiteStarted(final WebTestDescription suiteDescription) {
        this.forEachSafely(new Function<WebTestListener, Void>(){

            public Void apply(WebTestListener input) {
                input.suiteStarted(suiteDescription);
                return null;
            }
        });
    }

    @Override
    public void suiteFinished(final WebTestDescription suiteDescription) {
        this.forEachSafely(new Function<WebTestListener, Void>(){

            public Void apply(WebTestListener input) {
                input.suiteFinished(suiteDescription);
                return null;
            }
        });
    }

    @Override
    public void testError(final WebTestDescription test, final Throwable t) {
        this.forEachSafely(new Function<WebTestListener, Void>(){

            public Void apply(WebTestListener input) {
                input.testError(test, t);
                return null;
            }
        });
    }

    @Override
    public void testFailure(final WebTestDescription test, final Throwable t) {
        this.forEachSafely(new Function<WebTestListener, Void>(){

            public Void apply(WebTestListener input) {
                input.testFailure(test, t);
                return null;
            }
        });
    }

    @Override
    public void testFinished(final WebTestDescription test) {
        this.forEachSafely(new Function<WebTestListener, Void>(){

            public Void apply(WebTestListener input) {
                input.testFinished(test);
                return null;
            }
        });
    }

    @Override
    public void testStarted(final WebTestDescription test) {
        this.forEachSafely(new Function<WebTestListener, Void>(){

            public Void apply(WebTestListener input) {
                input.testStarted(test);
                return null;
            }
        });
    }

    private void forEachSafely(Function<WebTestListener, ?> call) {
        for (WebTestListener listener : this.listeners) {
            try {
                call.apply((Object)listener);
            }
            catch (Exception e) {
                log.error("Error occurred while running test listener.", (Throwable)e);
            }
        }
    }

    public static WebTestListener of(WebTestListener listener) {
        return listener;
    }

    public static WebTestListener of(WebTestListener ... listeners) {
        if (listeners == null || listeners.length == 0) {
            throw new IllegalArgumentException("listeners is null or empty");
        }
        if (listeners.length == 1) {
            return listeners[0];
        }
        return new CompositeSuiteListener(CollectionBuilder.newBuilder(listeners).asList());
    }
}

