/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config.ps;

import com.atlassian.jira.functest.config.ConfigException;
import com.atlassian.jira.functest.config.ConfigSequence;
import com.atlassian.jira.functest.config.ConfigXmlUtils;
import com.atlassian.jira.functest.config.ps.ConfigPropertySet;
import com.atlassian.jira.functest.config.ps.ConfigPropertySetEntry;
import com.atlassian.jira.functest.config.ps.ConfigPropertySetManager;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;

public class DefaultConfigPropertySetManager
implements ConfigPropertySetManager {
    private static final Map<ConfigPropertySetEntry.Type, PropertyValueHelper> valueHelper;
    private static final String ATTRIB_PROPERTY_KEY = "propertyKey";
    private static final String ATTRIB_ID = "id";
    private static final String ATTRIB_VALUE = "value";
    private static final String ATTRIB_TYPE = "type";
    private static final String ATTRIB_ENTITY_NAME = "entityName";
    private static final String ATTRIB_ENTITY_ID = "entityId";
    private static final String ELEMENT_OS_PROPERTY_ENTRY = "OSPropertyEntry";
    private static final String ELEMENT_OS_PROPERTY_NUMBER = "OSPropertyNumber";
    private static final String ELEMENT_OS_PROPERTY_TEXT = "OSPropertyText";
    private final Document document;
    private final ConfigSequence sequence;

    public DefaultConfigPropertySetManager(Document document, ConfigSequence sequence) {
        this.document = document;
        this.sequence = sequence;
    }

    @Override
    public ConfigPropertySet loadPropertySet(String entityName, long id) {
        ConfigPropertySet newSet = new ConfigPropertySet(entityName, id);
        List<Element> list = this.getEntries(entityName, id);
        for (Element element : list) {
            this.addForElement(newSet, element);
        }
        return newSet;
    }

    @Override
    public boolean savePropertySet(ConfigPropertySet propertySet) {
        boolean returnValue = false;
        ConfigPropertySet oldPropertySet = this.loadPropertySet(propertySet.getEntityName(), propertySet.getEntityId());
        Map<String, ConfigPropertySetEntry> oldEntries = oldPropertySet.entryMap();
        for (ConfigPropertySetEntry entry : propertySet.entries()) {
            ConfigPropertySetEntry oldEntry = oldEntries.get(entry.getPropertyName());
            if (oldEntry == null) {
                this.addEntry(propertySet, entry, this.sequence.getNextId(ELEMENT_OS_PROPERTY_ENTRY));
                returnValue = true;
                continue;
            }
            if (entry.equals(oldEntry)) continue;
            this.updateEntry(propertySet, entry, oldEntry);
            returnValue = true;
        }
        HashMap<String, ConfigPropertySetEntry> deleteMe = new HashMap<String, ConfigPropertySetEntry>(oldEntries);
        deleteMe.keySet().removeAll(propertySet.entryMap().keySet());
        for (ConfigPropertySetEntry deleteEntry : deleteMe.values()) {
            this.deleteEntry(propertySet, deleteEntry);
            returnValue = true;
        }
        return returnValue;
    }

    @Override
    public void deletePropertySet(ConfigPropertySet propertySet) {
        for (ConfigPropertySetEntry entry : propertySet.entries()) {
            this.deleteEntry(propertySet, entry);
        }
    }

    @Override
    public void deletePropertySet(String entityName, Long id) {
        List<Element> entries = this.getEntries(entityName, id);
        for (Element entry : entries) {
            Integer type = ConfigXmlUtils.getIntegerValue(entry, ATTRIB_TYPE);
            if (type == null) {
                throw new ConfigException("Unable to delete entry '" + DefaultConfigPropertySetManager.elementToString(entry) + "': Element has no type.");
            }
            PropertyValueHelper helper = this.getHelper(type);
            Long entryId = ConfigXmlUtils.getLongValue(entry, ATTRIB_ID);
            if (entryId == null) {
                throw new ConfigException("Unable to delete entry '" + DefaultConfigPropertySetManager.elementToString(entry) + ": Element does not have an ID.");
            }
            if (!helper.deleteEntry(this.document, entryId)) {
                throw new ConfigException("Unable to delete entry '" + DefaultConfigPropertySetManager.elementToString(entry) + ".");
            }
            ConfigXmlUtils.removeElement(entry);
        }
    }

    private void deleteEntry(ConfigPropertySet propertySet, ConfigPropertySetEntry entry) {
        Element osElement = this.getEntry(propertySet.getEntityName(), propertySet.getEntityId(), entry.getPropertyName());
        if (osElement == null) {
            throw new ConfigException("Unable to delete entry '" + entry + ": Unable to find current DOM element.");
        }
        PropertyValueHelper helper = valueHelper.get((Object)entry.getPropertyType());
        if (helper == null) {
            throw new ConfigException("Unable to delete entry '" + entry + ": Unable to find helper.");
        }
        Long id = ConfigXmlUtils.getLongValue(osElement, ATTRIB_ID);
        if (id == null) {
            throw new ConfigException("Unable to delete entry '" + entry + ": Element '" + DefaultConfigPropertySetManager.elementToString(osElement) + "' does not have an ID.");
        }
        if (!helper.deleteEntry(this.document, id)) {
            throw new ConfigException("Unable to delete entry'" + entry + "'.");
        }
        ConfigXmlUtils.removeElement(osElement);
    }

    private void updateEntry(ConfigPropertySet propertySet, ConfigPropertySetEntry newEntry, ConfigPropertySetEntry oldEntry) {
        PropertyValueHelper helper = valueHelper.get((Object)newEntry.getPropertyType());
        if (helper == null) {
            throw new ConfigException("Unable to update entry '" + oldEntry + "': Unable to find helper for type '" + (Object)((Object)newEntry.getPropertyType()) + "'.");
        }
        Element osElement = this.getEntry(propertySet.getEntityName(), propertySet.getEntityId(), newEntry.getPropertyName());
        if (osElement == null) {
            throw new ConfigException("Unable to update entry '" + oldEntry + "': Unable to find current DOM element.");
        }
        Long id = ConfigXmlUtils.getLongValue(osElement, ATTRIB_ID);
        if (id == null) {
            throw new ConfigException("Unable to update entry '" + oldEntry + "': Element '" + DefaultConfigPropertySetManager.elementToString(osElement) + "' does not have an ID.");
        }
        if (newEntry.getPropertyType() == oldEntry.getPropertyType()) {
            if (!helper.updateEntry(this.document, id, newEntry)) {
                throw new ConfigException("Unable to update entry '" + oldEntry + "' to '" + newEntry + "'.");
            }
        } else {
            PropertyValueHelper oldHelper = valueHelper.get((Object)oldEntry.getPropertyType());
            if (oldHelper == null) {
                throw new ConfigException("Unable to update entry '" + oldEntry + "': Unable to find helper for type '" + (Object)((Object)oldEntry.getPropertyType()) + "'.");
            }
            if (!oldHelper.deleteEntry(this.document, id)) {
                throw new ConfigException("Unable to update entry '" + oldEntry + "': Unable to delete old entry.");
            }
            ConfigXmlUtils.setAttribute(osElement, ATTRIB_TYPE, (Object)String.valueOf(newEntry.getPropertyType().getPropertySetType()));
            if (!helper.addEntryToDocument(this.document, id, newEntry)) {
                throw new ConfigException("Unable to update entry '" + oldEntry + "': Unable to create new entry '" + newEntry + "'.");
            }
        }
    }

    private void addEntry(ConfigPropertySet propertySet, ConfigPropertySetEntry newEntry, long newId) {
        PropertyValueHelper helper = valueHelper.get((Object)newEntry.getPropertyType());
        if (helper == null) {
            throw new ConfigException("Unable to add new entry '" + newEntry + "': Unable to find helper.");
        }
        Element newElement = ConfigXmlUtils.createNewElement(this.document.getRootElement(), ELEMENT_OS_PROPERTY_ENTRY);
        ConfigXmlUtils.setAttribute(newElement, ATTRIB_ID, (Object)String.valueOf(newId));
        ConfigXmlUtils.setAttribute(newElement, ATTRIB_ENTITY_NAME, (Object)propertySet.getEntityName());
        ConfigXmlUtils.setAttribute(newElement, ATTRIB_ENTITY_ID, (Object)propertySet.getEntityId().toString());
        ConfigXmlUtils.setAttribute(newElement, ATTRIB_PROPERTY_KEY, (Object)newEntry.getPropertyName());
        ConfigXmlUtils.setAttribute(newElement, ATTRIB_TYPE, (Object)String.valueOf(newEntry.getPropertyType().getPropertySetType()));
        if (!helper.addEntryToDocument(this.document, newId, newEntry)) {
            throw new ConfigException("Unable to create entry for '" + newEntry + "'.");
        }
    }

    private void addForElement(ConfigPropertySet set, Element entry) {
        String propertyKey = ConfigXmlUtils.getTextValue(entry, ATTRIB_PROPERTY_KEY);
        Long id = ConfigXmlUtils.getLongValue(entry, ATTRIB_ID);
        Integer type = ConfigXmlUtils.getIntegerValue(entry, ATTRIB_TYPE);
        if (StringUtils.isBlank((String)propertyKey) || id == null || type == null) {
            throw new ConfigException("Unable to read entry: '" + DefaultConfigPropertySetManager.elementToString(entry) + "'.");
        }
        PropertyValueHelper helper = this.getHelper(type);
        if (!helper.addEntryToPropertySet(this.document, propertyKey, id, set)) {
            throw new ConfigException("Unable to read entry: '" + DefaultConfigPropertySetManager.elementToString(entry) + "'.");
        }
    }

    private PropertyValueHelper getHelper(int type) {
        ConfigPropertySetEntry.Type entryType = ConfigPropertySetEntry.Type.forPropertySetType(type);
        if (entryType == null) {
            throw new ConfigException("Entry type with id '" + type + "' does not exist.");
        }
        PropertyValueHelper helper = valueHelper.get((Object)entryType);
        if (helper == null) {
            throw new ConfigException("Helper for entry type  '" + (Object)((Object)entryType) + "' does not exist.");
        }
        return helper;
    }

    private List<Element> getEntries(String entityName, long id) {
        String xpath = String.format("/entity-engine-xml/OSPropertyEntry[@entityName='%s' and @entityId='%d']", entityName, id);
        return ConfigXmlUtils.getElementsByXpath(this.document, xpath);
    }

    private Element getEntry(String entityName, long id, String propertyKey) {
        String xpath = String.format("/entity-engine-xml/OSPropertyEntry[@entityName='%s' and @entityId='%d' and @propertyKey='%s']", entityName, id, propertyKey);
        return ConfigXmlUtils.getElementByXpath(this.document, xpath);
    }

    private static Element getNumberEntry(Document document, long id) {
        return ConfigXmlUtils.getElementByXpath(document, String.format("/entity-engine-xml/OSPropertyNumber[@id='%d']", id));
    }

    private static Element addNumberEntry(Document document, long id, String value) {
        Element numberElement = ConfigXmlUtils.createNewElement(document.getRootElement(), ELEMENT_OS_PROPERTY_NUMBER);
        ConfigXmlUtils.setAttribute(numberElement, ATTRIB_ID, (Object)String.valueOf(id));
        ConfigXmlUtils.setAttribute(numberElement, ATTRIB_VALUE, (Object)value);
        return numberElement;
    }

    private static String elementToString(Element element) {
        StringWriter writer = new StringWriter();
        try {
            element.write((Writer)writer);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IO exception on string writer.", e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
        return writer.toString();
    }

    static {
        EnumMap<ConfigPropertySetEntry.Type, PropertyValueHelper> map = new EnumMap<ConfigPropertySetEntry.Type, PropertyValueHelper>(ConfigPropertySetEntry.Type.class);
        map.put(ConfigPropertySetEntry.Type.BOOLEAN, new BooleanValueHelper());
        map.put(ConfigPropertySetEntry.Type.INTEGER, new IntegerValueHelper());
        map.put(ConfigPropertySetEntry.Type.LONG, new LongValueHelper());
        map.put(ConfigPropertySetEntry.Type.STRING, new StringValueHelper());
        map.put(ConfigPropertySetEntry.Type.TEXT, new TextValueHelper());
        valueHelper = Collections.unmodifiableMap(map);
    }

    private static class TextValueHelper
    implements PropertyValueHelper {
        private TextValueHelper() {
        }

        @Override
        public ConfigPropertySetEntry.Type getType() {
            return ConfigPropertySetEntry.Type.TEXT;
        }

        @Override
        public boolean addEntryToPropertySet(Document document, String propertyName, long id, ConfigPropertySet ps) {
            String stringValue;
            Element element = TextValueHelper.getTextElement(document, id);
            if (element != null && (stringValue = ConfigXmlUtils.getTextValue(element, DefaultConfigPropertySetManager.ATTRIB_VALUE)) != null) {
                ps.setTextProperty(propertyName, stringValue);
                return true;
            }
            return false;
        }

        @Override
        public boolean addEntryToDocument(Document document, long id, ConfigPropertySetEntry entry) {
            Element element = ConfigXmlUtils.createNewElement(document.getRootElement(), DefaultConfigPropertySetManager.ELEMENT_OS_PROPERTY_TEXT);
            ConfigXmlUtils.setAttribute(element, DefaultConfigPropertySetManager.ATTRIB_ID, (Object)String.valueOf(id));
            ConfigXmlUtils.setAttribute(element, DefaultConfigPropertySetManager.ATTRIB_VALUE, (Object)entry.asString());
            return true;
        }

        @Override
        public boolean updateEntry(Document document, long id, ConfigPropertySetEntry newEntry) {
            Element element = TextValueHelper.getTextElement(document, id);
            if (element != null) {
                ConfigXmlUtils.setAttribute(element, DefaultConfigPropertySetManager.ATTRIB_VALUE, (Object)newEntry.asString());
                return true;
            }
            return false;
        }

        @Override
        public boolean deleteEntry(Document document, long id) {
            Element element = TextValueHelper.getTextElement(document, id);
            return ConfigXmlUtils.removeElement(element);
        }

        private static Element getTextElement(Document document, long id) {
            return ConfigXmlUtils.getElementByXpath(document, String.format("/entity-engine-xml/OSPropertyText[@id='%d']", id));
        }
    }

    private static class StringValueHelper
    implements PropertyValueHelper {
        private static final String ELEMENT_OS_PROPERTY_STRING = "OSPropertyString";

        private StringValueHelper() {
        }

        @Override
        public ConfigPropertySetEntry.Type getType() {
            return ConfigPropertySetEntry.Type.STRING;
        }

        @Override
        public boolean addEntryToPropertySet(Document document, String propertyName, long id, ConfigPropertySet ps) {
            Element element = StringValueHelper.getStringElement(document, id);
            if (element != null) {
                String stringValue = ConfigXmlUtils.getTextValue(element, DefaultConfigPropertySetManager.ATTRIB_VALUE);
                ps.setStringProperty(propertyName, stringValue);
                return true;
            }
            return false;
        }

        @Override
        public boolean addEntryToDocument(Document document, long id, ConfigPropertySetEntry entry) {
            Element element = ConfigXmlUtils.createNewElement(document.getRootElement(), ELEMENT_OS_PROPERTY_STRING);
            ConfigXmlUtils.setAttribute(element, DefaultConfigPropertySetManager.ATTRIB_ID, (Object)String.valueOf(id));
            ConfigXmlUtils.setAttribute(element, DefaultConfigPropertySetManager.ATTRIB_VALUE, (Object)entry.asString());
            return true;
        }

        @Override
        public boolean updateEntry(Document document, long id, ConfigPropertySetEntry newEntry) {
            Element element = StringValueHelper.getStringElement(document, id);
            if (element != null) {
                ConfigXmlUtils.setAttribute(element, DefaultConfigPropertySetManager.ATTRIB_VALUE, (Object)newEntry.asString());
                return true;
            }
            return false;
        }

        @Override
        public boolean deleteEntry(Document document, long id) {
            Element element = StringValueHelper.getStringElement(document, id);
            return ConfigXmlUtils.removeElement(element);
        }

        private static Element getStringElement(Document document, long id) {
            return ConfigXmlUtils.getElementByXpath(document, String.format("/entity-engine-xml/OSPropertyString[@id='%d']", id));
        }
    }

    private static class LongValueHelper
    implements PropertyValueHelper {
        private LongValueHelper() {
        }

        @Override
        public ConfigPropertySetEntry.Type getType() {
            return ConfigPropertySetEntry.Type.LONG;
        }

        @Override
        public boolean addEntryToPropertySet(Document document, String propertyName, long id, ConfigPropertySet ps) {
            Long integerValue;
            Element element = DefaultConfigPropertySetManager.getNumberEntry(document, id);
            if (element != null && (integerValue = ConfigXmlUtils.getLongValue(element, DefaultConfigPropertySetManager.ATTRIB_VALUE)) != null) {
                ps.setLongProperty(propertyName, integerValue);
                return true;
            }
            return false;
        }

        @Override
        public boolean addEntryToDocument(Document document, long id, ConfigPropertySetEntry entry) {
            DefaultConfigPropertySetManager.addNumberEntry(document, id, entry.asString());
            return true;
        }

        @Override
        public boolean updateEntry(Document document, long id, ConfigPropertySetEntry newEntry) {
            Element element = DefaultConfigPropertySetManager.getNumberEntry(document, id);
            if (element != null) {
                ConfigXmlUtils.setAttribute(element, DefaultConfigPropertySetManager.ATTRIB_VALUE, (Object)newEntry.asString());
                return true;
            }
            return false;
        }

        @Override
        public boolean deleteEntry(Document document, long id) {
            Element element = DefaultConfigPropertySetManager.getNumberEntry(document, id);
            return ConfigXmlUtils.removeElement(element);
        }
    }

    private static class IntegerValueHelper
    implements PropertyValueHelper {
        private IntegerValueHelper() {
        }

        @Override
        public ConfigPropertySetEntry.Type getType() {
            return ConfigPropertySetEntry.Type.INTEGER;
        }

        @Override
        public boolean addEntryToPropertySet(Document document, String propertyName, long id, ConfigPropertySet ps) {
            Integer integerValue;
            Element element = DefaultConfigPropertySetManager.getNumberEntry(document, id);
            if (element != null && (integerValue = ConfigXmlUtils.getIntegerValue(element, DefaultConfigPropertySetManager.ATTRIB_VALUE)) != null) {
                ps.setIntegerProperty(propertyName, integerValue);
                return true;
            }
            return false;
        }

        @Override
        public boolean addEntryToDocument(Document document, long id, ConfigPropertySetEntry entry) {
            DefaultConfigPropertySetManager.addNumberEntry(document, id, entry.asString());
            return true;
        }

        @Override
        public boolean updateEntry(Document document, long id, ConfigPropertySetEntry newEntry) {
            Element element = DefaultConfigPropertySetManager.getNumberEntry(document, id);
            if (element != null) {
                ConfigXmlUtils.setAttribute(element, DefaultConfigPropertySetManager.ATTRIB_VALUE, (Object)newEntry.asString());
                return true;
            }
            return false;
        }

        @Override
        public boolean deleteEntry(Document document, long id) {
            Element element = DefaultConfigPropertySetManager.getNumberEntry(document, id);
            return ConfigXmlUtils.removeElement(element);
        }
    }

    private static class BooleanValueHelper
    implements PropertyValueHelper {
        private BooleanValueHelper() {
        }

        @Override
        public ConfigPropertySetEntry.Type getType() {
            return ConfigPropertySetEntry.Type.BOOLEAN;
        }

        @Override
        public boolean addEntryToPropertySet(Document document, String propertyName, long id, ConfigPropertySet ps) {
            Integer boolValue;
            Element element = DefaultConfigPropertySetManager.getNumberEntry(document, id);
            if (element != null && (boolValue = ConfigXmlUtils.getIntegerValue(element, DefaultConfigPropertySetManager.ATTRIB_VALUE)) != null) {
                ps.setBooleanProperty(propertyName, boolValue != 0);
                return true;
            }
            return false;
        }

        @Override
        public boolean addEntryToDocument(Document document, long id, ConfigPropertySetEntry entry) {
            DefaultConfigPropertySetManager.addNumberEntry(document, id, this.asBoolean(entry));
            return true;
        }

        @Override
        public boolean updateEntry(Document document, long id, ConfigPropertySetEntry newEntry) {
            Element element = DefaultConfigPropertySetManager.getNumberEntry(document, id);
            if (element != null) {
                ConfigXmlUtils.setAttribute(element, DefaultConfigPropertySetManager.ATTRIB_VALUE, (Object)this.asBoolean(newEntry));
                return true;
            }
            return false;
        }

        @Override
        public boolean deleteEntry(Document document, long id) {
            Element element = DefaultConfigPropertySetManager.getNumberEntry(document, id);
            return ConfigXmlUtils.removeElement(element);
        }

        private String asBoolean(ConfigPropertySetEntry entry) {
            return entry.asBoolean() != false ? "1" : "0";
        }
    }

    private static interface PropertyValueHelper {
        public ConfigPropertySetEntry.Type getType();

        public boolean addEntryToPropertySet(Document var1, String var2, long var3, ConfigPropertySet var5);

        public boolean addEntryToDocument(Document var1, long var2, ConfigPropertySetEntry var4);

        public boolean updateEntry(Document var1, long var2, ConfigPropertySetEntry var4);

        public boolean deleteEntry(Document var1, long var2);
    }
}

