/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config.ps;

public abstract class ConfigPropertySetEntry {
    private final String propertyName;
    private final Type propertyType;

    public ConfigPropertySetEntry(String propertyName, Type propertyType) {
        this.propertyName = propertyName;
        this.propertyType = propertyType;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Type getPropertyType() {
        return this.propertyType;
    }

    public abstract String asString();

    public abstract Long asLong();

    public abstract Boolean asBoolean();

    public abstract Integer asInteger();

    public abstract Object asObject();

    public static ConfigPropertySetEntry createStringEntry(String name, String value) {
        return new StringEntry(name, Type.STRING, value);
    }

    public static ConfigPropertySetEntry createTextEntry(String name, String value) {
        return new StringEntry(name, Type.TEXT, value);
    }

    public static ConfigPropertySetEntry createIntegerEntry(String name, Integer value) {
        return new IntegerEntry(name, value);
    }

    public static ConfigPropertySetEntry createLongEntry(String name, Long value) {
        return new LongEntry(name, value);
    }

    public static ConfigPropertySetEntry createBooleanEntry(String name, Boolean b) {
        return new BooleanEntry(name, b);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigPropertySetEntry that = (ConfigPropertySetEntry)o;
        if (this.propertyName != null ? !this.propertyName.equals(that.propertyName) : that.propertyName != null) {
            return false;
        }
        return this.propertyType == that.propertyType;
    }

    public int hashCode() {
        int result = this.propertyName != null ? this.propertyName.hashCode() : 0;
        result = 31 * result + (this.propertyType != null ? this.propertyType.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("%s(%s): %s", this.propertyName, this.propertyType.name(), this.asString());
    }

    private static class BooleanEntry
    extends ConfigPropertySetEntry {
        private final Boolean value;

        private BooleanEntry(String propertyName, Boolean value) {
            super(propertyName, Type.BOOLEAN);
            this.value = value;
        }

        @Override
        public String asString() {
            return this.value != null ? this.value.toString() : null;
        }

        @Override
        public Long asLong() {
            if (this.value != null) {
                return this.value != false ? 1L : 0L;
            }
            return null;
        }

        @Override
        public Boolean asBoolean() {
            return this.value;
        }

        @Override
        public Integer asInteger() {
            if (this.value != null) {
                return this.value != false ? 1 : 0;
            }
            return null;
        }

        @Override
        public Object asObject() {
            return this.value;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            BooleanEntry that = (BooleanEntry)o;
            return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }
    }

    private static class LongEntry
    extends ConfigPropertySetEntry {
        private final Long value;

        private LongEntry(String propertyName, Long value) {
            super(propertyName, Type.LONG);
            this.value = value;
        }

        @Override
        public String asString() {
            return this.value != null ? this.value.toString() : null;
        }

        @Override
        public Long asLong() {
            return this.value;
        }

        @Override
        public Boolean asBoolean() {
            return this.value != null && this.value != 0L;
        }

        @Override
        public Integer asInteger() {
            if (this.value != null) {
                int tmpValue = this.value.intValue();
                return (long)tmpValue != this.value ? null : Integer.valueOf(tmpValue);
            }
            return null;
        }

        @Override
        public Object asObject() {
            return this.value;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LongEntry longEntry = (LongEntry)o;
            return !(this.value != null ? !this.value.equals(longEntry.value) : longEntry.value != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }
    }

    private static class IntegerEntry
    extends ConfigPropertySetEntry {
        private final Integer value;

        private IntegerEntry(String propertyName, Integer value) {
            super(propertyName, Type.INTEGER);
            this.value = value;
        }

        @Override
        public String asString() {
            return this.value != null ? this.value.toString() : null;
        }

        @Override
        public Long asLong() {
            return this.value != null ? Long.valueOf(this.value.longValue()) : null;
        }

        @Override
        public Boolean asBoolean() {
            return this.value != null && this.value != 0;
        }

        @Override
        public Integer asInteger() {
            return this.value;
        }

        @Override
        public Object asObject() {
            if (this.getPropertyType() == Type.BOOLEAN) {
                return this.asBoolean();
            }
            return this.value;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            IntegerEntry that = (IntegerEntry)o;
            return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }
    }

    private static class StringEntry
    extends ConfigPropertySetEntry {
        private final String value;

        public StringEntry(String propertyName, Type propertyType, String value) {
            super(propertyName, propertyType);
            this.value = value;
        }

        @Override
        public String asString() {
            return this.value;
        }

        @Override
        public Long asLong() {
            if (this.value != null) {
                try {
                    return new Long(this.value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        public Boolean asBoolean() {
            Integer integer = this.asInteger();
            return integer != null && integer != 0;
        }

        @Override
        public Integer asInteger() {
            if (this.value != null) {
                try {
                    return new Integer(this.value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        public Object asObject() {
            return this.value;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            StringEntry that = (StringEntry)o;
            return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }
    }

    public static enum Type {
        STRING(5),
        TEXT(6),
        INTEGER(2),
        LONG(3),
        BOOLEAN(1);

        private int psType;

        private Type(int psType) {
            this.psType = psType;
        }

        public int getPropertySetType() {
            return this.psType;
        }

        public static Type forPropertySetType(int psType) {
            for (Type type : Type.values()) {
                if (type.getPropertySetType() != psType) continue;
                return type;
            }
            return null;
        }
    }
}

