/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config.mail;

import com.atlassian.jira.functest.config.CheckOptions;
import com.atlassian.jira.functest.config.CheckResultBuilder;
import com.atlassian.jira.functest.config.ConfigurationCheck;
import com.atlassian.jira.functest.config.JiraConfig;
import com.atlassian.jira.functest.config.mail.ConfigMailServer;
import com.atlassian.jira.functest.config.service.ConfigService;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class MailChecker
implements ConfigurationCheck {
    public static final String CHECK_MAIL_SERVER = "mailserver";
    public static final String CHECK_MAIL_SERVICE = "mailservice";
    public static final List<String> SERVICES = Arrays.asList("MailFetcherService", "FileService");

    @Override
    public ConfigurationCheck.Result checkConfiguration(JiraConfig config, CheckOptions options) {
        CheckResultBuilder resultBuilder = new CheckResultBuilder();
        if (options.checkEnabled(CHECK_MAIL_SERVER)) {
            for (ConfigMailServer mailServer : config.getMailServers()) {
                String name = mailServer.getName() == null ? mailServer.getId().toString() : mailServer.getName();
                String type = mailServer.getType() == null ? "<unknown type>" : mailServer.getType().name();
                String serverName = mailServer.getServerName() == null ? "<unknown server>" : mailServer.getServerName();
                String username = mailServer.getUserName() == null ? "<anonymous>" : mailServer.getUserName();
                resultBuilder.error(String.format("Mail server '%s' to '%s:%s' for user '%s' exists.", name, type, serverName, username), CHECK_MAIL_SERVER);
            }
        }
        if (options.checkEnabled(CHECK_MAIL_SERVICE)) {
            List<ConfigService> configServiceList = config.getServices();
            for (ConfigService service : configServiceList) {
                for (String clazzName : SERVICES) {
                    if (!service.getClazz().contains(clazzName)) continue;
                    String name = service.getName();
                    if (StringUtils.isBlank((String)name)) {
                        name = service.getId().toString();
                    }
                    resultBuilder.error(String.format("Mail service '%s' exists.", name), CHECK_MAIL_SERVICE);
                }
            }
        }
        return resultBuilder.buildResult();
    }

    @Override
    public void fixConfiguration(JiraConfig config, CheckOptions options) {
        if (options.checkEnabled(CHECK_MAIL_SERVER)) {
            config.getMailServers().clear();
        }
        if (options.checkEnabled(CHECK_MAIL_SERVICE)) {
            List<ConfigService> configServiceList = config.getServices();
            Iterator<ConfigService> serviceIterator = configServiceList.iterator();
            while (serviceIterator.hasNext()) {
                ConfigService service = serviceIterator.next();
                for (String clazzName : SERVICES) {
                    if (!service.getClazz().contains(clazzName)) continue;
                    serviceIterator.remove();
                }
            }
        }
    }
}

