/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config.dashboard;

import com.atlassian.jira.functest.config.CheckOptions;
import com.atlassian.jira.functest.config.CheckResultBuilder;
import com.atlassian.jira.functest.config.ConfigurationCheck;
import com.atlassian.jira.functest.config.JiraConfig;
import com.atlassian.jira.functest.config.dashboard.ConfigDashboard;
import com.atlassian.jira.functest.config.dashboard.ConfigExternalGadget;
import com.atlassian.jira.functest.config.dashboard.ConfigGadget;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class DashboardConfigurationCheck
implements ConfigurationCheck {
    public static final String CHECKID_DASHBOARDS = "dashboards";
    public static final String CHECKID_GADGETS = "gadgets";
    public static final String CHECKID_EXTERNAL = "externalgadgets";
    public static final String CHECKID_ABSOLUTE = "absolutegadgets";
    private static final Pattern ABSOLUTE_REGEX = Pattern.compile("^https?://", 2);

    @Override
    public ConfigurationCheck.Result checkConfiguration(JiraConfig config, CheckOptions options) {
        CheckResultBuilder builder = new CheckResultBuilder();
        List<ConfigDashboard> dashboards = config.getDashboards();
        Set<String> externalUrls = this.getExternalGadgetUrls(config);
        for (ConfigDashboard dashboard : dashboards) {
            if (options.checkEnabled(CHECKID_DASHBOARDS) && !dashboard.isSystem()) {
                builder.error(String.format("Non-system dashboard '%s' (%d) exists.", DashboardConfigurationCheck.getName(dashboard), dashboard.getId()), CHECKID_DASHBOARDS);
                continue;
            }
            if (dashboard.getGadgets().isEmpty()) continue;
            if (options.checkEnabled(CHECKID_GADGETS)) {
                builder.error(String.format("Gadget on dashboard '%s' (%d).", DashboardConfigurationCheck.getName(dashboard), dashboard.getId()), CHECKID_GADGETS);
                continue;
            }
            if (!options.checkEnabled(CHECKID_ABSOLUTE)) continue;
            for (ConfigGadget gadget : dashboard.getGadgets()) {
                if (externalUrls.contains(DashboardConfigurationCheck.toLowerCase(gadget.getGadgetXml())) || !DashboardConfigurationCheck.isAbsoluteUrl(gadget)) continue;
                builder.error(String.format("Gadget URL '%s' is absolute on dashboard '%s' (%d).", gadget.getGadgetXml(), DashboardConfigurationCheck.getName(dashboard), dashboard.getId()), CHECKID_ABSOLUTE);
            }
        }
        if (options.checkEnabled(CHECKID_EXTERNAL)) {
            for (String externalUrl : externalUrls) {
                builder.error(String.format("External gadget '%s' configured.", externalUrl), CHECKID_EXTERNAL);
            }
        }
        return builder.buildResult();
    }

    @Override
    public void fixConfiguration(JiraConfig config, CheckOptions options) {
        List<ConfigDashboard> dashboards = config.getDashboards();
        Iterator<ConfigDashboard> dashboardIterator = dashboards.iterator();
        while (dashboardIterator.hasNext()) {
            ConfigDashboard dashboard = dashboardIterator.next();
            if (options.checkEnabled(CHECKID_DASHBOARDS) && !dashboard.isSystem()) {
                dashboardIterator.remove();
                continue;
            }
            if (dashboard.getGadgets().isEmpty()) continue;
            this.checkGadgets(config, options, dashboard);
        }
        if (options.checkEnabled(CHECKID_EXTERNAL)) {
            config.getExternalGadgets().clear();
        }
    }

    private void checkGadgets(JiraConfig config, CheckOptions options, ConfigDashboard dashboard) {
        if (options.checkEnabled(CHECKID_GADGETS)) {
            dashboard.getGadgets().clear();
        } else if (options.checkEnabled(CHECKID_ABSOLUTE) || options.checkEnabled(CHECKID_EXTERNAL)) {
            Set<String> externalUrls = this.getExternalGadgetUrls(config);
            boolean changed = false;
            Iterator<ConfigGadget> remove = dashboard.getGadgets().iterator();
            while (remove.hasNext()) {
                ConfigGadget gadget = remove.next();
                if (externalUrls.contains(DashboardConfigurationCheck.toLowerCase(gadget.getGadgetXml()))) {
                    if (!options.checkEnabled(CHECKID_EXTERNAL)) continue;
                    changed = true;
                    remove.remove();
                    continue;
                }
                if (!options.checkEnabled(CHECKID_ABSOLUTE) || !DashboardConfigurationCheck.isAbsoluteUrl(gadget)) continue;
                changed = true;
                remove.remove();
            }
            if (changed) {
                dashboard.reorderGadgets();
            }
        }
    }

    private static boolean isAbsoluteUrl(ConfigGadget gadget) {
        return gadget.getGadgetXml() != null && ABSOLUTE_REGEX.matcher(gadget.getGadgetXml()).find();
    }

    private static String toLowerCase(String str) {
        return str == null ? null : str.toLowerCase(Locale.ENGLISH);
    }

    private Set<String> getExternalGadgetUrls(JiraConfig config) {
        HashSet<String> urls = new HashSet<String>();
        List<ConfigExternalGadget> gadgets = config.getExternalGadgets();
        for (ConfigExternalGadget gadget : gadgets) {
            String xml = gadget.getGadgetXml();
            if (!StringUtils.isNotBlank((String)xml)) continue;
            urls.add(xml.toLowerCase(Locale.ENGLISH));
        }
        return urls;
    }

    private static String getName(ConfigDashboard dashboard) {
        String name = dashboard.getName();
        return StringUtils.isBlank((String)name) ? "<unknown>" : name;
    }
}

