/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config.crowd;

import com.atlassian.jira.functest.config.ConfigCrudHelper;
import com.atlassian.jira.functest.config.ConfigException;
import com.atlassian.jira.functest.config.ConfigSequence;
import com.atlassian.jira.functest.config.ConfigXmlUtils;
import com.atlassian.jira.functest.config.crowd.ConfigCrowdApplication;
import com.atlassian.jira.functest.config.crowd.ConfigCrowdApplicationManager;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class DefaultConfigCrowdApplicationManager
implements ConfigCrowdApplicationManager {
    private final ConfigCrudHelper<ConfigCrowdApplication> helper;

    public DefaultConfigCrowdApplicationManager(Document document, ConfigSequence sequence) {
        this.helper = new Helper(document, sequence);
    }

    @Override
    public List<ConfigCrowdApplication> loadApplications() {
        return this.helper.load();
    }

    @Override
    public boolean saveApplications(List<ConfigCrowdApplication> applications) {
        return this.helper.save(applications);
    }

    static class Helper
    extends ConfigCrudHelper<ConfigCrowdApplication> {
        private static final String ELEMENT_APPLICATION = "Application";
        private static final String ATTRIBUTE_ID = "id";
        private static final String ATTRIBUTE_NAME = "name";
        private static final String ATTRIBUTE_LOWER_NAME = "lowerName";
        private static final String ATTRIBUTE_ACTIVE = "active";
        private static final String ATTRIBUTE_APPLICATION_TYPE = "applicationType";

        Helper(Document document, ConfigSequence configSeqence) {
            super(document, configSeqence, ELEMENT_APPLICATION);
        }

        @Override
        protected ConfigCrowdApplication elementToObject(Element element) {
            Long id = ConfigXmlUtils.getLongValue(element, ATTRIBUTE_ID);
            if (id == null) {
                throw new ConfigException("Trying to read application without an ID.");
            }
            ConfigCrowdApplication currentApplication = new ConfigCrowdApplication();
            currentApplication.setId(id);
            currentApplication.setName(ConfigXmlUtils.getTextValue(element, ATTRIBUTE_NAME));
            currentApplication.setLowerName(ConfigXmlUtils.getTextValue(element, ATTRIBUTE_LOWER_NAME));
            currentApplication.setActive(Helper.getBoolean(element, ATTRIBUTE_ACTIVE));
            currentApplication.setApplicationType(ConfigXmlUtils.getTextValue(element, ATTRIBUTE_APPLICATION_TYPE));
            return currentApplication;
        }

        @Override
        protected void updateObject(Element element, ConfigCrowdApplication updateObject, ConfigCrowdApplication oldObject) {
            this.setAttributes(element, updateObject);
        }

        @Override
        protected void newObject(Element element, ConfigCrowdApplication newObject, Long newId) {
            this.setAttributes(element, newObject);
            ConfigXmlUtils.setAttribute(element, ATTRIBUTE_ID, newId);
        }

        @Override
        protected void deleteObject(Element element, ConfigCrowdApplication deleteObject) {
        }

        private void setAttributes(Element element, ConfigCrowdApplication newObject) {
            ConfigXmlUtils.setAttribute(element, ATTRIBUTE_NAME, (Object)newObject.getName());
            ConfigXmlUtils.setAttribute(element, ATTRIBUTE_LOWER_NAME, (Object)newObject.getLowerName());
            ConfigXmlUtils.setAttribute(element, ATTRIBUTE_ACTIVE, newObject.isActive() == null ? null : (newObject.isActive() != false ? "1" : "0"));
            ConfigXmlUtils.setAttribute(element, ATTRIBUTE_APPLICATION_TYPE, (Object)newObject.getApplicationType());
        }

        private static Boolean getBoolean(Element element, String attribute) {
            Integer value = ConfigXmlUtils.getIntegerValue(element, attribute);
            if (value == null) {
                return null;
            }
            return value == 1;
        }
    }
}

