/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config;

import com.atlassian.jira.functest.framework.FuncTestSuite;
import com.atlassian.jira.webtests.util.TestClassUtils;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.junit.Ignore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MissingTestFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(MissingTestFinder.class);

    public void assertAllTestsInTestHarness(String packageForAllTests, String harnessSuiteName, Set<Class<? extends TestCase>> testsDefinedInSuite, Set<Class<? extends TestCase>> testsToIgnore) {
        this.assertAllTestsInTestHarness(TestClassUtils.getJUnit3TestClasses(packageForAllTests), harnessSuiteName, testsDefinedInSuite, testsToIgnore);
    }

    public void assertAllTestsInTestHarness(List<Class<? extends TestCase>> allTestCases, String harnessSuiteName, Set<Class<? extends TestCase>> testsDefinedInSuite, final Set<Class<? extends TestCase>> testsToIgnore) {
        ImmutableList allTestsExceptIgnored = ImmutableList.copyOf((Iterable)Iterables.filter(allTestCases, (Predicate)new Predicate<Class<? extends TestCase>>(){

            public boolean apply(Class<? extends TestCase> testClass) {
                return testClass.getSimpleName().startsWith("Test") && !testsToIgnore.contains(testClass);
            }
        }));
        Sets.SetView ignoredButRunning = Sets.intersection((Set)Sets.newHashSet(testsDefinedInSuite), testsToIgnore);
        for (Class testClass : ignoredButRunning) {
            LOGGER.error(String.format("Test %s is marked with @%s but will be run.", testClass.getName(), Ignore.class.getSimpleName()));
        }
        Sets.SetView missingTestClasses = Sets.difference((Set)Sets.newHashSet((Iterable)allTestsExceptIgnored), (Set)Sets.newHashSet(testsDefinedInSuite));
        if (!missingTestClasses.isEmpty()) {
            StringBuilder missingTests = new StringBuilder();
            for (Class testClass : missingTestClasses) {
                missingTests.append("\n  ").append(testClass.getName());
            }
            Assert.fail((String)("Found " + missingTestClasses.size() + " Tests that are unknown to " + harnessSuiteName + ":" + missingTests.toString() + "\n. See subclasses of " + FuncTestSuite.class.getSimpleName() + " for details.\n"));
        }
    }
}

