/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config;

import com.atlassian.jira.webtests.util.TestClassUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JUnit4Suppressor {
    private static final Logger log = LoggerFactory.getLogger(JUnit4Suppressor.class);
    private final List<Class<? extends TestCase>> testsInSuite;
    private List<Violation> violations;

    public JUnit4Suppressor(Collection<Class<? extends TestCase>> testsInSuite) {
        this.testsInSuite = new ArrayList<Class<? extends TestCase>>(testsInSuite);
    }

    public void killJUnit4() {
        this.violations = new ArrayList<Violation>();
        for (Class<? extends TestCase> testClass : this.testsInSuite) {
            this.checkNoJUnit4ConstructsInTest(testClass);
        }
        if (!this.violations.isEmpty()) {
            Assert.fail((String)this.message());
        }
    }

    private void checkNoJUnit4ConstructsInTest(Class<? extends TestCase> testClass) {
        log.debug("Verifying class " + testClass.getName());
        this.checkNoJUnit4Constructs(testClass);
        for (Method testMethod : TestClassUtils.getTestMethods(testClass)) {
            log.debug("    Veryfing method " + testClass.getSimpleName() + "." + testMethod.getName());
            this.checkNoJUnit4Constructs(testMethod);
        }
    }

    private void checkNoJUnit4Constructs(AnnotatedElement annotated) {
        this.checkViolation(annotated, Test.class);
        this.checkViolation(annotated, Before.class);
        this.checkViolation(annotated, After.class);
    }

    private void checkViolation(AnnotatedElement offender, Class<? extends Annotation> offence) {
        if (offender.getAnnotation(offence) != null) {
            log.debug("FAIL");
            this.violations.add(new Violation(offender, offence));
        }
    }

    private String message() {
        StringBuilder builder = new StringBuilder(this.violations.size() * 20).append("Found following JUnit4 constructs:\n");
        for (Violation violation : this.violations) {
            builder.append(" -- ").append(violation).append('\n');
        }
        return builder.toString();
    }

    private static class Violation {
        private final AnnotatedElement offender;
        private final Class<? extends Annotation> offence;

        public Violation(AnnotatedElement offender, Class<? extends Annotation> offence) {
            this.offender = offender;
            this.offence = offence;
        }

        public String toString() {
            return "Test <" + this.offender + "> is annotated with " + this.offence.getName();
        }
    }
}

