/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FuncProperties {
    private static final String JIRA_FUNC_PROPERTIES = "/jira-func.properties";
    private static final Logger log = LoggerFactory.getLogger(FuncProperties.class);

    public static String get(String propertyName) {
        InputStream is = FuncProperties.class.getResourceAsStream(JIRA_FUNC_PROPERTIES);
        if (is == null) {
            throw new IllegalStateException("File not found in classpath: /jira-func.properties");
        }
        try {
            Properties props = new Properties();
            props.load(is);
            String string = props.getProperty(propertyName);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                log.error("Error closing file", (Throwable)e);
            }
        }
    }
}

