/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config;

import com.atlassian.jira.functest.config.CheckOptions;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;

public final class CheckOptionsUtils {
    private static final AllOptions ALL_OPTIONS = new AllOptions();
    private static final NoOptions NO_OPTIONS = new NoOptions();
    private static final String ALL_OPTION = "all";
    private static final Pattern PATTERN_FIND_OPTION = Pattern.compile("^\\s*suppresschecks?(?::|\\s)(.*?)$", 10);
    private static final Pattern PATTERN_CLEAN_LINES = Pattern.compile("\\s*$\\s+?^?", 8);

    private CheckOptionsUtils() {
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Can't clone me, I'm a loner.");
    }

    public static CheckOptions allOptions() {
        return ALL_OPTIONS;
    }

    public static CheckOptions noOptions() {
        return NO_OPTIONS;
    }

    public static CheckOptions disabled(String ... options) {
        return new DisabledOptions(Arrays.asList(options));
    }

    public static CheckOptions disableIn(CheckOptions original, String ... newDisabledOptions) {
        HashSet<String> allDisabled = new HashSet<String>(original.asSuppressChecks());
        allDisabled.addAll(Lists.newArrayList((Object[])newDisabledOptions));
        return new DisabledOptions(allDisabled);
    }

    public static CheckOptions parseOptions(Document document) {
        HashSet<String> checkExcludes = new HashSet<String>();
        for (Comment comment : CheckOptionsUtils.getComments(document)) {
            String s = comment.getText();
            Matcher matcher = PATTERN_FIND_OPTION.matcher(s);
            int pos = 0;
            while (pos < s.length() && matcher.find(pos)) {
                String[] parsedOptions;
                for (String parsedOption : parsedOptions = matcher.group(1).split(Pattern.quote(","))) {
                    if (CheckOptionsUtils.isAllOption(parsedOption = CheckOptionsUtils.normalizeOption(parsedOption))) {
                        return CheckOptionsUtils.noOptions();
                    }
                    checkExcludes.add(parsedOption);
                }
                pos = matcher.end() + 1;
            }
        }
        if (checkExcludes.isEmpty()) {
            return CheckOptionsUtils.allOptions();
        }
        return new DisabledOptions(checkExcludes);
    }

    public static void writeOptions(Document document, CheckOptions options) {
        boolean update;
        Set<String> suppressOptions = options.asSuppressChecks();
        List<Comment> comments = CheckOptionsUtils.getComments(document);
        String optionStr = StringUtils.join((Collection)ImmutableSortedSet.copyOf(suppressOptions), (String)", ");
        boolean bl = update = !suppressOptions.isEmpty();
        if (comments.isEmpty()) {
            if (update) {
                CheckOptionsUtils.addTopLevelComment(document, String.format("%n%n    suppresschecks: %s%n%n", optionStr));
            }
        } else if (CheckOptionsUtils.hasExistingChecks(comments)) {
            CheckOptionsUtils.replaceExistingCheck(comments, optionStr);
        } else if (update) {
            Comment comment = comments.get(0);
            comment.setText(String.format("%n%n    suppresschecks: %s%n%n%s", optionStr, CheckOptionsUtils.startLineTrim(comment.getText())));
        }
    }

    private static boolean hasExistingChecks(List<Comment> comments) {
        for (Comment comment : comments) {
            if (!PATTERN_FIND_OPTION.matcher(comment.getText()).find()) continue;
            return true;
        }
        return false;
    }

    private static void replaceExistingCheck(List<Comment> comments, String optionStr) {
        boolean updated = false;
        for (Comment comment : comments) {
            Matcher matcher = PATTERN_FIND_OPTION.matcher(comment.getText());
            if (!matcher.find()) continue;
            comment.setText(matcher.replaceFirst(Matcher.quoteReplacement(CheckOptionsUtils.replacementString(optionStr))));
            updated = true;
            break;
        }
        if (!updated) {
            throw new AssertionError((Object)"Did not find comment to update");
        }
    }

    private static String replacementString(String optionStr) {
        return StringUtils.isEmpty((String)optionStr) ? optionStr : "    suppresschecks: " + optionStr;
    }

    private static String startLineTrim(String string) {
        Matcher matcher = PATTERN_CLEAN_LINES.matcher(string);
        if (matcher.find() && matcher.start() == 0) {
            return string.substring(matcher.end());
        }
        return string;
    }

    private static List<Comment> getComments(Document document) {
        return document.selectNodes("/comment()");
    }

    private static Comment addTopLevelComment(Document document, String comment) {
        List list = document.content();
        DocumentFactory factory = DocumentFactory.getInstance();
        Comment commentNode = factory.createComment(comment);
        list.add(0, commentNode);
        list.add(1, factory.createText("\n"));
        return commentNode;
    }

    private static boolean isAllOption(String option) {
        return ALL_OPTION.equalsIgnoreCase(option);
    }

    private static String normalizeOption(String checkId) {
        if ((checkId = StringUtils.trimToNull((String)checkId)) != null) {
            return checkId.toLowerCase(Locale.ENGLISH);
        }
        return null;
    }

    private static class DisabledOptions
    implements CheckOptions {
        private final Set<String> disabledOptions;

        public DisabledOptions(Collection<String> disabledOptions) {
            HashSet<String> strings = new HashSet<String>();
            for (String option : disabledOptions) {
                if ((option = CheckOptionsUtils.normalizeOption(option)) == null) continue;
                strings.add(option);
            }
            this.disabledOptions = Collections.unmodifiableSet(strings);
        }

        @Override
        public boolean checkEnabled(String checkId) {
            return !this.disabledOptions.contains(CheckOptionsUtils.normalizeOption(checkId));
        }

        @Override
        public Set<String> asSuppressChecks() {
            return this.disabledOptions;
        }
    }

    private static class NoOptions
    implements CheckOptions {
        private NoOptions() {
        }

        @Override
        public boolean checkEnabled(String checkId) {
            return false;
        }

        @Override
        public Set<String> asSuppressChecks() {
            return Collections.singleton(CheckOptionsUtils.ALL_OPTION);
        }
    }

    private static class AllOptions
    implements CheckOptions {
        private AllOptions() {
        }

        @Override
        public boolean checkEnabled(String checkId) {
            return true;
        }

        @Override
        public Set<String> asSuppressChecks() {
            return Collections.emptySet();
        }
    }
}

