/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.baseurl;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.net.URI;
import java.net.URISyntaxException;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class BaseUrl {
    private final ApplicationProperties applicationProperties;

    @Inject
    public BaseUrl(@ComponentImport ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public boolean isEquivalentTo(String uri) {
        try {
            return new URI(uri).equals(this.asUri());
        }
        catch (URISyntaxException invalidUriArguments) {
            return uri.equals(this.asString());
        }
    }

    public URI asUri() throws URISyntaxException {
        return new URI(this.asString());
    }

    public String asString() {
        return this.applicationProperties.getString("jira.baseurl");
    }
}

