/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.services.mail;

import com.atlassian.annotations.Internal;
import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.configurable.ObjectConfigurable;
import com.atlassian.configurable.ObjectConfiguration;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.mail.MailLoggingManager;
import com.atlassian.jira.mail.settings.MailSettings;
import com.atlassian.jira.service.services.file.AbstractMessageHandlingService;
import com.atlassian.jira.service.services.mail.DeadLetterStore;
import com.atlassian.jira.service.services.mail.DelegatingMessageHandlerContext;
import com.atlassian.jira.service.services.mail.ErrorAccumulatingMessageHandlerExecutionMonitor;
import com.atlassian.jira.service.services.mail.MailServicesHelper;
import com.atlassian.jira.service.util.handler.MessageHandler;
import com.atlassian.jira.service.util.handler.MessageHandlerContext;
import com.atlassian.jira.service.util.handler.MessageHandlerExecutionMonitor;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.MailProtocol;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.util.TextUtils;
import com.sun.mail.imap.IMAPMessage;
import com.sun.mail.pop3.POP3Message;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Store;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchTerm;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.exception.VelocityException;

@Internal
public class MailFetcherService
extends AbstractMessageHandlingService
implements ObjectConfigurable {
    private static final Logger log = ComponentAccessor.getComponent(MailLoggingManager.class).getIncomingMailChildLogger("mailfetcherservice");
    public static final String KEY_MAIL_SERVER = "popserver";
    protected Long mailserverId = null;
    protected Long configurationIdentifier = null;
    public static final String FORWARD_EMAIL = "forwardEmail";
    protected static final String DEFAULT_FOLDER = "INBOX";
    public static final String FOLDER_NAME_KEY = "foldername";
    public static final String MARK_AS_SEEN_KEY = "markasseen";
    private static final String EMAIL_TEMPLATES = "templates/email/";
    private final MailSettings.Fetch settings;
    private static final String ERROR_TEMPLATE = "errorinhandler.vm";
    private final ErrorEmailForwarder errorEmailForwarder;
    private final MessageProvider messageProvider;
    private final DeadLetterStore deadLetterStore;
    private final ClusterLockService clusterLockService;

    @VisibleForTesting
    MailFetcherService(MailSettings.Fetch settings, ErrorEmailForwarder errorEmailForwarder, MessageProvider messageProvider, DeadLetterStore deadLetterStore) {
        this.settings = settings;
        this.errorEmailForwarder = errorEmailForwarder;
        this.messageProvider = messageProvider;
        this.deadLetterStore = deadLetterStore;
        this.clusterLockService = ComponentAccessor.getComponent(ClusterLockService.class);
    }

    public MailFetcherService() {
        this.errorEmailForwarder = new ErrorEmailForwarderImpl();
        this.messageProvider = new MessageProviderImpl();
        this.settings = ComponentAccessor.getComponent(MailSettings.class).fetch();
        this.deadLetterStore = this.getDeadLetterStore();
        this.clusterLockService = ComponentAccessor.getComponent(ClusterLockService.class);
    }

    @Override
    public void init(PropertySet props, long configurationIdentifier) throws ObjectConfigurationException {
        this.init(props);
        this.configurationIdentifier = configurationIdentifier;
    }

    @Override
    public void init(PropertySet props) throws ObjectConfigurationException {
        super.init(props);
        if (this.hasProperty(KEY_MAIL_SERVER)) {
            try {
                this.mailserverId = new Long(this.getProperty(KEY_MAIL_SERVER));
            }
            catch (Exception e) {
                log.error((Object)("Invalid mail server id: " + e), (Throwable)e);
            }
        }
    }

    protected MailProcessMode getMailProcessMode(MailProtocol mailProtocol, FeatureManager featureManager) {
        return MailProcessMode.get(mailProtocol, this.isMarkAsSeen(), featureManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runImpl(MessageHandlerContext context) {
        log.debug((Object)(this.getClass().getSimpleName() + " run() method has been called"));
        if (this.isMailDisabled()) {
            context.getMonitor().info("Mail is disabled.");
            return;
        }
        MessageHandler messageHandler = this.getHandler();
        if (messageHandler == null) {
            log.error((Object)"Message Handler is not configured properly for this service. Exiting.");
            return;
        }
        MailServer mailServer = this.getMailServer(context.getMonitor());
        if (mailServer == null) {
            context.getMonitor().warning("no mail server returned from getMailServer(). Exiting run()");
            return;
        }
        if (this.configurationIdentifier == null) {
            log.warn((Object)"Unknown execution id. This is probably a test run.");
        } else {
            log.debug((Object)("Execution id: " + this.configurationIdentifier));
        }
        String lockName = MailFetcherService.class.getName() + "." + this.configurationIdentifier;
        ClusterLock lock = this.clusterLockService.getLockForName(lockName);
        if (!lock.tryLock()) {
            log.debug((Object)String.format("Unable to acquire %s lock. Skipping the run.", lockName));
            return;
        }
        try {
            this.processMessages(context, mailServer);
        }
        finally {
            lock.unlock();
        }
    }

    private void processMessages(MessageHandlerContext context, MailServer mailServer) {
        this.deadLetterStore.deleteOldDeadLetters();
        this.messageProvider.getAndProcessMail(this::processMessage, mailServer, context);
    }

    private boolean processMessage(Message message, MessageHandlerContext context) throws MessagingException, MailException {
        ErrorAccumulatingMessageHandlerExecutionMonitor accumulatingMonitor = new ErrorAccumulatingMessageHandlerExecutionMonitor(context.getMonitor());
        DelegatingMessageHandlerContext myMessageHandlerContext = new DelegatingMessageHandlerContext(context, accumulatingMonitor);
        log.debug((Object)"Calling handleMessage");
        boolean deleteThisMessage = this.getHandler().handleMessage(message, myMessageHandlerContext);
        if ((accumulatingMonitor.hasErrors() && !deleteThisMessage || accumulatingMonitor.isMessagedMarkedForDeletion() || accumulatingMonitor.isMarkedToForward()) && this.forwardEmailParam() != null) {
            String toAddress = this.forwardEmailParam();
            log.debug((Object)("Forwarding error message to '" + toAddress + "'"));
            deleteThisMessage = this.errorEmailForwarder.forwardEmail(message, myMessageHandlerContext, toAddress, accumulatingMonitor.getErrorsAsString(), accumulatingMonitor.getExceptionsAsString());
        }
        return deleteThisMessage || accumulatingMonitor.isMessagedMarkedForDeletion();
    }

    @VisibleForTesting
    Optional<Store> getConnectedStore(MailServer mailServer, MessageHandlerExecutionMonitor monitor) {
        return MailServicesHelper.newInstance(mailServer, monitor).getConnectedStore();
    }

    @VisibleForTesting
    DeadLetterStore getDeadLetterStore() {
        return new DeadLetterStore(log);
    }

    private MailServer getMailServer(MessageHandlerExecutionMonitor monitor) {
        MailServer mailserver = null;
        if (this.mailserverId != null) {
            try {
                mailserver = this.getMailServerManager().getMailServer(new Long(this.getProperty(KEY_MAIL_SERVER)));
            }
            catch (Exception e) {
                monitor.error("Could not retrieve mail server: " + e, e);
            }
        } else {
            monitor.error(this.getClass().getName() + " cannot run without a configured Mail Server");
        }
        return mailserver;
    }

    @VisibleForTesting
    MailServerManager getMailServerManager() {
        return MailFactory.getServerManager();
    }

    @Deprecated
    boolean isMailDisabled() {
        return this.settings.isDisabled();
    }

    protected String getFolderName(MailServer server) {
        if (server.getMailProtocol().equals((Object)MailProtocol.SECURE_IMAP) || server.getMailProtocol().equals((Object)MailProtocol.IMAP)) {
            try {
                return StringUtils.defaultString((String)this.getProperty(FOLDER_NAME_KEY), (String)DEFAULT_FOLDER);
            }
            catch (ObjectConfigurationException e) {
                throw new DataAccessException("Error retrieving foldername.", (Throwable)((Object)e));
            }
        }
        return DEFAULT_FOLDER;
    }

    protected boolean isMarkAsSeen() {
        try {
            return Boolean.parseBoolean(this.getProperty(MARK_AS_SEEN_KEY));
        }
        catch (ObjectConfigurationException e) {
            throw new DataAccessException("Error retrieving markasseen.", (Throwable)((Object)e));
        }
    }

    private String forwardEmailParam() {
        try {
            return this.getProperty(FORWARD_EMAIL);
        }
        catch (ObjectConfigurationException e) {
            throw new DataAccessException(this.addHandlerInfo("Error retrieving Forward Email flag."), (Throwable)((Object)e));
        }
    }

    @Override
    protected String addHandlerInfo(String msg) {
        return this.getName() + "[" + this.mailserverId + "]: " + msg;
    }

    private static I18nHelper getI18nHelper() {
        return ComponentAccessor.getI18nHelperFactory().getInstance((ApplicationUser)null);
    }

    @Override
    public ObjectConfiguration getObjectConfiguration() throws ObjectConfigurationException {
        return this.getObjectConfiguration("MAILFETCHERSERVICE", "services/com/atlassian/jira/service/services/mail/mailfetcherservice.xml", null);
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    @Internal
    @VisibleForTesting
    static enum MailProcessMode {
        DELETE_LEGACY{

            @Override
            public void process(@Nonnull Message message) throws MessagingException {
                message.setFlag(Flags.Flag.DELETED, true);
            }

            @Override
            public FlagTerm getFlagTerm() {
                return new FlagTerm(new Flags(Flags.Flag.DELETED), false);
            }
        }
        ,
        DELETE{

            @Override
            public void process(@Nonnull Message message) throws MessagingException {
                message.setFlag(Flags.Flag.DELETED, true);
            }

            @Override
            public FlagTerm getFlagTerm() {
                Flags flagsThatShouldBeNotPresent = new Flags(Flags.Flag.DELETED);
                flagsThatShouldBeNotPresent.add(Flags.Flag.SEEN);
                return new FlagTerm(flagsThatShouldBeNotPresent, false);
            }
        }
        ,
        SEEN{

            @Override
            public void process(@Nonnull Message message) throws MessagingException {
                message.setFlag(Flags.Flag.SEEN, true);
            }

            @Override
            public FlagTerm getFlagTerm() {
                Flags flagsThatShouldBeNotPresent = new Flags(Flags.Flag.DELETED);
                flagsThatShouldBeNotPresent.add(Flags.Flag.SEEN);
                return new FlagTerm(flagsThatShouldBeNotPresent, false);
            }
        };


        static MailProcessMode get(@Nullable MailProtocol mailProtocol, boolean isMarkAsRead, @Nonnull FeatureManager featureManager) {
            if (mailProtocol == null) {
                return DELETE_LEGACY;
            }
            switch (mailProtocol) {
                case IMAP: 
                case SECURE_IMAP: {
                    if (isMarkAsRead) {
                        return SEEN;
                    }
                    if (featureManager.isEnabled("com.atlassian.jira.mailHandlerImapMessageQueryLegacy")) {
                        return DELETE_LEGACY;
                    }
                    return DELETE;
                }
            }
            return DELETE_LEGACY;
        }

        public abstract void process(@Nonnull Message var1) throws MessagingException;

        public abstract FlagTerm getFlagTerm();
    }

    private class ErrorEmailForwarderImpl
    implements ErrorEmailForwarder {
        private ErrorEmailForwarderImpl() {
        }

        @Override
        public boolean forwardEmail(Message message, MessageHandlerContext context, String toAddress, String errorsAsString, String exceptionsAsString) {
            if (TextUtils.verifyEmail((String)toAddress)) {
                try {
                    com.atlassian.jira.mail.Email email = this.createErrorForwardEmail(message, context.getMonitor(), toAddress, errorsAsString, exceptionsAsString);
                    this.sendMail(email, context, context.getMonitor());
                    return true;
                }
                catch (VelocityException e) {
                    context.getMonitor().error("Could not create email template for.", e);
                }
                catch (MessagingException e) {
                    context.getMonitor().error("Could not retrieve information from message.", e);
                }
                catch (MailException e) {
                    context.getMonitor().error("Failed to forward the message.", e);
                }
            } else {
                context.getMonitor().warning("Forward Email is invalid.");
            }
            return false;
        }

        private void sendMail(com.atlassian.jira.mail.Email email, MessageHandlerContext context, MessageHandlerExecutionMonitor messageHandlerExecutionMonitor) throws MailException {
            SMTPMailServer mailserver = MailFetcherService.this.getMailServerManager().getDefaultSMTPMailServer();
            if (mailserver == null) {
                messageHandlerExecutionMonitor.warning("You do not currently have a smtp mail server set up yet.");
            } else if (MailFactory.isSendingDisabled()) {
                messageHandlerExecutionMonitor.warning("Sending mail is currently disabled in Jira.");
            } else {
                email.setFrom(mailserver.getDefaultFrom());
                if (context.isRealRun()) {
                    log.debug((Object)("Sending mail to [" + email.getTo() + "]"));
                    mailserver.send((Email)email);
                } else {
                    messageHandlerExecutionMonitor.info("Sending mail to '" + email.getTo() + "'");
                    log.debug((Object)("Sending mail to [" + email.getTo() + "] skipped due to dry-run mode"));
                }
            }
        }

        private com.atlassian.jira.mail.Email createErrorForwardEmail(Message message, MessageHandlerExecutionMonitor monitor, String toAddress, String errorsAsString, @Nullable String exceptionsAsString) throws VelocityException, MessagingException {
            com.atlassian.jira.mail.Email email = new com.atlassian.jira.mail.Email(toAddress);
            email.setSubject(MailFetcherService.getI18nHelper().getText("template.errorinhandler.subject", message.getSubject()));
            HashMap<String, Object> contextParams = new HashMap<String, Object>();
            contextParams.putAll(this.getVelocityParams(errorsAsString, monitor));
            String body = this.getTemplatingEngine().render(TemplateSources.file("templates/email/text/errorinhandler.vm")).applying(contextParams).asPlainText();
            email.setBody(body);
            MimeMultipart mp = new MimeMultipart();
            if (exceptionsAsString != null) {
                MimeBodyPart exception = new MimeBodyPart();
                exception.setContent((Object)exceptionsAsString, "text/plain");
                exception.setFileName("ErrorStackTrace.txt");
                mp.addBodyPart((BodyPart)exception);
            }
            MimeBodyPart messageAttachment = new MimeBodyPart();
            messageAttachment.setContent((Object)message, "message/rfc822");
            String subject = message.getSubject();
            if (StringUtils.isBlank((CharSequence)subject)) {
                subject = "NoSubject";
            }
            messageAttachment.setFileName(subject + ".eml");
            mp.addBodyPart((BodyPart)messageAttachment);
            email.setMultipart((Multipart)mp);
            return email;
        }

        private Map<String, Object> getVelocityParams(String error, MessageHandlerExecutionMonitor messageHandlerExecutionMonitor) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            String handlerName = MailFetcherService.this.getHandler().getClass().toString();
            try {
                params.put("i18n", MailFetcherService.getI18nHelper());
                params.put("handlerName", handlerName);
                Long serverId = new Long(MailFetcherService.this.getProperty(MailFetcherService.KEY_MAIL_SERVER));
                params.put("serverName", MailFetcherService.this.getMailServerManager().getMailServer(serverId).getName());
                params.put("error", error);
                params.put("baseurl", ComponentAccessor.getApplicationProperties().getString("jira.baseurl"));
            }
            catch (ObjectConfigurationException e) {
                messageHandlerExecutionMonitor.error("Could not retrieve mail server", (Throwable)((Object)e));
            }
            catch (MailException e) {
                messageHandlerExecutionMonitor.error("Could not retrieve mail server", e);
            }
            return params;
        }

        @VisibleForTesting
        VelocityTemplatingEngine getTemplatingEngine() {
            return ComponentAccessor.getComponent(VelocityTemplatingEngine.class);
        }
    }

    private class MessageProviderImpl
    implements MessageProvider {
        static final String MESSAGE_ID = "Message-ID";

        private MessageProviderImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void getAndProcessMail(MessageProvider.SingleMessageProcessor singleMessageProcessor, MailServer mailserver, MessageHandlerContext context) {
            log.debug((Object)("Using mail server [" + mailserver + "]"));
            Optional<Store> storeOptional = MailFetcherService.this.getConnectedStore(mailserver, context.getMonitor());
            if (!storeOptional.isPresent()) {
                return;
            }
            String hostname = mailserver.getHostname();
            String protocol = mailserver.getMailProtocol().getProtocol();
            Store store = storeOptional.get();
            Folder folder = null;
            ArrayList pop3MessagesToBeDeleted = Lists.newArrayList();
            try {
                String folderName = MailFetcherService.this.getFolderName(mailserver);
                log.debug((Object)("Getting folder [" + folderName + "]"));
                folder = store.getFolder(folderName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Got folder [" + folder + "], now opening it for read/write"));
                }
                folder.open(!context.isRealRun() ? 1 : 2);
                MailProcessMode mailProcessMode = MailFetcherService.this.getMailProcessMode(mailserver.getMailProtocol(), ComponentAccessor.getComponent(FeatureManager.class));
                Message[] messages = this.getUnprocessedMessages(folder, mailProcessMode);
                log.debug((Object)MailFetcherService.this.addHandlerInfo(String.format("Found %d unprocessed message(s) (%s) in the %s folder", new Object[]{messages.length, mailProcessMode, protocol})));
                if (!context.isRealRun()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Found ");
                    sb.append(messages.length);
                    sb.append(" unprocessed message(s) (").append((Object)mailProcessMode).append(") in the ");
                    sb.append(protocol);
                    sb.append(" folder.");
                    if (messages.length > 10) {
                        sb.append(" Only first 10 messages will be processed in test mode.");
                    }
                    context.getMonitor().info(sb.toString());
                }
                context.getMonitor().setNumMessages(messages.length);
                int messagesLength = messages.length;
                for (int i = 0; i < messagesLength; ++i) {
                    String msgId;
                    boolean markThisMessageAsProcessed;
                    Message message;
                    block34: {
                        message = messages[i];
                        this.setPeekForImapMessage(message);
                        markThisMessageAsProcessed = false;
                        msgId = null;
                        context.getMonitor().nextMessage(message);
                        if (context.isRealRun() || i < 10) break block34;
                        log.debug((Object)"In dry-run mode only first 10 messages are processed. Skipping the rest");
                        if (message == null) break;
                        if (message instanceof POP3Message) {
                            ((POP3Message)message).invalidate(true);
                        }
                        if (!markThisMessageAsProcessed) break;
                        if (context.isRealRun()) {
                            this.markMessageAsProcessed(message, msgId, folderName, mailProcessMode, pop3MessagesToBeDeleted);
                            break;
                        }
                        context.getMonitor().info("Marking message as processed '" + message.getSubject() + "'");
                        log.debug((Object)("Deleting message: " + msgId + " (skipped due to dry-run mode)"));
                        break;
                    }
                    try {
                        log.debug((Object)"Processing message");
                        String[] messageIdHeader = message.getHeader(MESSAGE_ID);
                        String string = msgId = messageIdHeader != null ? messageIdHeader[0] : null;
                        if (log.isDebugEnabled()) {
                            try {
                                log.debug((Object)("Message Subject: " + message.getSubject()));
                                log.debug((Object)("Message-ID: " + msgId));
                            }
                            catch (MessagingException e) {
                                context.getMonitor().warning("Messaging exception thrown on getting message subject. Message may have corrupt headers.", e);
                            }
                        }
                        if (MailFetcherService.this.deadLetterStore.exists(msgId, MailFetcherService.this.mailserverId, folderName)) {
                            context.getMonitor().warning("Marking message '" + message.getSubject() + "' as processed without processing in order to avoid creating duplicate issues/comments. This message has been already processed by a mail handler on this mailbox before.");
                            markThisMessageAsProcessed = true;
                        } else {
                            markThisMessageAsProcessed = singleMessageProcessor.process(message, context);
                        }
                        if (message == null) continue;
                    }
                    catch (FolderClosedException fce) {
                        context.getMonitor().error("The folder has been closed on us, stop processing any more emails: " + fce.getMessage(), fce);
                        log.debug((Object)("The folder was closed while talking to the service: " + mailserver.getHostname()));
                        if (message == null) break;
                        if (message instanceof POP3Message) {
                            ((POP3Message)message).invalidate(true);
                        }
                        if (!markThisMessageAsProcessed) break;
                        if (context.isRealRun()) {
                            this.markMessageAsProcessed(message, msgId, folderName, mailProcessMode, pop3MessagesToBeDeleted);
                            break;
                        }
                        context.getMonitor().info("Marking message as processed '" + message.getSubject() + "'");
                        log.debug((Object)("Deleting message: " + msgId + " (skipped due to dry-run mode)"));
                        break;
                    }
                    catch (Exception e) {
                        context.getMonitor().error("Exception: " + e.getLocalizedMessage(), e);
                        if (message == null) continue;
                        {
                            catch (Throwable throwable) {
                                if (message != null) {
                                    if (message instanceof POP3Message) {
                                        ((POP3Message)message).invalidate(true);
                                    }
                                    if (markThisMessageAsProcessed) {
                                        if (context.isRealRun()) {
                                            this.markMessageAsProcessed(message, msgId, folderName, mailProcessMode, pop3MessagesToBeDeleted);
                                        } else {
                                            context.getMonitor().info("Marking message as processed '" + message.getSubject() + "'");
                                            log.debug((Object)("Deleting message: " + msgId + " (skipped due to dry-run mode)"));
                                        }
                                    }
                                }
                                throw throwable;
                            }
                        }
                        if (message instanceof POP3Message) {
                            ((POP3Message)message).invalidate(true);
                        }
                        if (!markThisMessageAsProcessed) continue;
                        if (context.isRealRun()) {
                            this.markMessageAsProcessed(message, msgId, folderName, mailProcessMode, pop3MessagesToBeDeleted);
                            continue;
                        }
                        context.getMonitor().info("Marking message as processed '" + message.getSubject() + "'");
                        log.debug((Object)("Deleting message: " + msgId + " (skipped due to dry-run mode)"));
                        continue;
                    }
                    if (message instanceof POP3Message) {
                        ((POP3Message)message).invalidate(true);
                    }
                    if (!markThisMessageAsProcessed) continue;
                    if (context.isRealRun()) {
                        this.markMessageAsProcessed(message, msgId, folderName, mailProcessMode, pop3MessagesToBeDeleted);
                        continue;
                    }
                    context.getMonitor().info("Marking message as processed '" + message.getSubject() + "'");
                    log.debug((Object)("Deleting message: " + msgId + " (skipped due to dry-run mode)"));
                    continue;
                }
                this.closeFolderAndStore(context, hostname, store, folder, pop3MessagesToBeDeleted);
            }
            catch (MessagingException e) {
                try {
                    context.getMonitor().error("Messaging Exception in service '" + this.getClass().getName() + "' when getting mail: " + e.getMessage(), e);
                    this.closeFolderAndStore(context, hostname, store, folder, pop3MessagesToBeDeleted);
                }
                catch (Throwable throwable) {
                    this.closeFolderAndStore(context, hostname, store, folder, pop3MessagesToBeDeleted);
                    throw throwable;
                }
            }
        }

        private Message[] getUnprocessedMessages(Folder folder, MailProcessMode mailProcessMode) throws MessagingException {
            return folder.search((SearchTerm)mailProcessMode.getFlagTerm());
        }

        private void setPeekForImapMessage(Message message) {
            if (message instanceof IMAPMessage) {
                ((IMAPMessage)message).setPeek(true);
            }
        }

        void markMessageAsProcessed(Message message, String msgId, String folderName, MailProcessMode mailProcessMode, List<String> pop3MessagesToBeDeleted) throws MessagingException {
            log.debug((Object)String.format("Marking Message as processed (%s): %s", new Object[]{mailProcessMode, msgId}));
            try {
                mailProcessMode.process(message);
                if (message instanceof POP3Message) {
                    pop3MessagesToBeDeleted.add(msgId);
                    MailFetcherService.this.deadLetterStore.createOrUpdate(msgId, MailFetcherService.this.mailserverId, folderName);
                } else {
                    MailFetcherService.this.deadLetterStore.delete(msgId, MailFetcherService.this.mailserverId, folderName);
                }
            }
            catch (MessagingException ex) {
                MailFetcherService.this.deadLetterStore.createOrUpdate(msgId, MailFetcherService.this.mailserverId, folderName);
                throw ex;
            }
        }

        private void closeFolderAndStore(MessageHandlerContext context, String hostname, Store store, Folder folder, List<String> pop3MessagesToBeDeleted) {
            try {
                if (folder != null) {
                    log.debug((Object)"Closing folder");
                    if (!folder.isOpen()) {
                        context.getMonitor().error("The connection is no longer open, messages marked as deleted will not be purged from the remote server: " + hostname + " until the next run.");
                    }
                    folder.close(true);
                }
                log.debug((Object)"Closing store");
                store.close();
                pop3MessagesToBeDeleted.forEach(msgId -> MailFetcherService.this.deadLetterStore.delete((String)msgId, MailFetcherService.this.mailserverId, MailFetcherService.DEFAULT_FOLDER));
            }
            catch (Exception e) {
                log.debug((Object)MailFetcherService.this.addHandlerInfo("Error whilst closing folder and store: " + e.getMessage()));
            }
        }
    }

    static interface ErrorEmailForwarder {
        public boolean forwardEmail(Message var1, MessageHandlerContext var2, String var3, String var4, String var5);
    }

    static interface MessageProvider {
        public void getAndProcessMail(SingleMessageProcessor var1, MailServer var2, MessageHandlerContext var3);

        public static interface SingleMessageProcessor {
            public boolean process(Message var1, MessageHandlerContext var2) throws MessagingException, MailException;
        }
    }
}

