/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import java.util.Map;
import java.util.Optional;

public final class JiraWebContext {
    private final Map<String, Object> context;

    private JiraWebContext(Map<String, Object> context) {
        this.context = context;
    }

    public static JiraWebContext from(Map<String, Object> context) {
        return new JiraWebContext(context);
    }

    public Optional<ApplicationUser> getUser() {
        return Optional.ofNullable(this.get("user", ApplicationUser.class).orElseGet(this::getUserByUsername));
    }

    private ApplicationUser getUserByUsername() {
        return this.getUsername().map(username -> ComponentAccessor.getUserManager().getUserByName((String)username)).orElse(null);
    }

    public Optional<JiraHelper> getHelper() {
        return this.get("helper", JiraHelper.class);
    }

    public Optional<I18nHelper> getI18n() {
        return this.get("i18n", I18nHelper.class);
    }

    public Optional<String> getUsername() {
        return this.get("username", String.class);
    }

    public Optional<String> getLocation() {
        return this.get("location", String.class);
    }

    public <T> Optional<T> get(String key, Class<T> type) {
        Object value = this.context.get(key);
        return type.isInstance(value) ? Optional.ofNullable(type.cast(value)) : Optional.empty();
    }
}

