/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.jira.config.AnalyticsAwareFeatureFlag;
import com.atlassian.jira.config.FeatureFlag;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.commons.lang3.Validate;

public class FeatureFlagDefinitions {
    private final Set<FeatureFlag> flags = Sets.newCopyOnWriteArraySet();

    public Set<FeatureFlag> getFeatureFlags() {
        return ImmutableSet.copyOf(this.flags);
    }

    public Definition featureFlag(String featureKey) {
        this.validate(featureKey);
        return new Definition(FeatureFlag.featureFlag(featureKey));
    }

    private void validate(String featureKey) {
        Validate.notNull((Object)featureKey, (String)"featureKey must not be null", (Object[])new Object[0]);
        Validate.isTrue((boolean)this.featureKeyIsNotEndWithPrefix(featureKey), (String)"Invalid feature key provided, key should be of the form 'my.feature.flag', NOT 'my.feature.flag.enabled' or 'my.feature.flag.disabled'", (Object[])new Object[0]);
        Validate.isTrue((boolean)this.featureKeyDoesNotExists(featureKey), (String)String.format("Feature key %s already registered", featureKey), (Object[])new Object[0]);
    }

    private boolean featureKeyIsNotEndWithPrefix(String featureKey) {
        return !featureKey.endsWith(".enabled") && !featureKey.endsWith(".disabled");
    }

    private boolean featureKeyDoesNotExists(String featureKey) {
        for (FeatureFlag featureFlag : this.flags) {
            if (!featureKey.equals(featureFlag.featureKey())) continue;
            return false;
        }
        return true;
    }

    public class Definition {
        private FeatureFlag flag;

        Definition(FeatureFlag flag) {
            this.flag = flag;
        }

        public Definition offByDefault() {
            this.flag = this.flag.offByDefault();
            return this;
        }

        public Definition onByDefault() {
            this.flag = this.flag.onByDefault();
            return this;
        }

        public Definition safeFlag() {
            this.flag = AnalyticsAwareFeatureFlag.convertToSafeFeatureFlag(this.flag);
            return this;
        }

        public Definition unsafeFlag() {
            this.flag = AnalyticsAwareFeatureFlag.convertToUnsafeFeatureFlag(this.flag);
            return this;
        }

        public FeatureFlag define() {
            FeatureFlagDefinitions.this.flags.add(this.flag);
            return this.flag;
        }
    }
}

