/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.profile;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class DarkFeatures {
    private final Set<String> systemEnabledFeatures;
    private final Set<String> siteEnabledFeatures;
    private final Set<String> userEnabledFeatures;
    private final Set<String> allEnabledFeatures;
    private final Set<String> globalEnabledFeatures;

    public DarkFeatures(Set<String> systemEnabledFeatures, Set<String> siteEnabledFeatures, Set<String> userEnabledFeatures) {
        this.systemEnabledFeatures = ImmutableSet.copyOf(systemEnabledFeatures);
        this.userEnabledFeatures = ImmutableSet.copyOf(userEnabledFeatures);
        this.siteEnabledFeatures = ImmutableSet.copyOf(siteEnabledFeatures);
        HashSet features = Sets.newHashSet(systemEnabledFeatures);
        features.addAll(siteEnabledFeatures);
        this.globalEnabledFeatures = ImmutableSet.copyOf((Collection)features);
        features.addAll(userEnabledFeatures);
        this.allEnabledFeatures = ImmutableSet.copyOf((Collection)features);
    }

    public Set<String> getSystemEnabledFeatures() {
        return this.systemEnabledFeatures;
    }

    public Set<String> getSiteEnabledFeatures() {
        return this.siteEnabledFeatures;
    }

    public Set<String> getUserEnabledFeatures() {
        return this.userEnabledFeatures;
    }

    public Set<String> getGlobalEnabledFeatureKeys() {
        return this.globalEnabledFeatures;
    }

    public Set<String> getAllEnabledFeatures() {
        return this.allEnabledFeatures;
    }

    public boolean isFeatureEnabled(String featureKey) {
        return this.getAllEnabledFeatures().contains(StringUtils.trim((String)featureKey));
    }
}

