/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.context;

import com.atlassian.jira.jql.context.AllIssueTypesContext;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.ClauseContextImpl;
import com.atlassian.jira.jql.context.ProjectContextImpl;
import com.atlassian.jira.jql.context.ProjectIssueTypeContext;
import com.atlassian.jira.jql.context.ProjectIssueTypeContextImpl;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class AbstractProjectAttributeClauseContextFactory<T>
implements ClauseContextFactory {
    private final IndexInfoResolver<T> indexInfoResolver;
    private final JqlOperandResolver jqlOperandResolver;
    private final PermissionManager permissionManager;

    protected AbstractProjectAttributeClauseContextFactory(IndexInfoResolver<T> indexInfoResolver, JqlOperandResolver jqlOperandResolver, PermissionManager permissionManager) {
        this.permissionManager = Assertions.notNull("permissionManager", permissionManager);
        this.jqlOperandResolver = Assertions.notNull("jqlOperandResolver", jqlOperandResolver);
        this.indexInfoResolver = Assertions.notNull("indexInfoResolver", indexInfoResolver);
    }

    @Override
    public ClauseContext getClauseContext(ApplicationUser searcher, TerminalClause terminalClause) {
        if (this.jqlOperandResolver.isEmptyOperand(terminalClause.getOperand())) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        ClauseContext context = this.getContextFromClause(searcher, terminalClause);
        if (context.getContexts().isEmpty()) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        return context;
    }

    abstract ClauseContext getContextFromClause(ApplicationUser var1, TerminalClause var2);

    Set<ProjectIssueTypeContext> getContextsForProject(ApplicationUser searcher, Project project) {
        if (project == null || !this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, project, searcher)) {
            return Collections.emptySet();
        }
        return Collections.singleton(new ProjectIssueTypeContextImpl(new ProjectContextImpl(project.getId()), AllIssueTypesContext.INSTANCE));
    }

    boolean isNegationOperator(Operator operator) {
        return operator == Operator.NOT_EQUALS || operator == Operator.NOT_IN || operator == Operator.IS_NOT;
    }

    boolean isRelationalOperator(Operator operator) {
        return OperatorClasses.RELATIONAL_ONLY_OPERATORS.contains((Object)operator);
    }

    boolean isEqualityOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains((Object)operator);
    }

    List<Long> getIds(QueryLiteral literal) {
        List<String> ids;
        Assertions.notNull("literal", literal);
        if (literal.getStringValue() != null) {
            ids = this.indexInfoResolver.getIndexedValues(literal.getStringValue());
        } else if (literal.getLongValue() != null) {
            ids = this.indexInfoResolver.getIndexedValues(literal.getLongValue());
        } else {
            throw new IllegalStateException("Invalid query literal");
        }
        return CollectionUtil.transform(ids, new Function<String, Long>(){

            @Override
            public Long apply(String input) {
                return Long.parseLong(input);
            }
        });
    }
}

