/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;

public class QueryCreationContextImpl
implements QueryCreationContext {
    private final ApplicationUser user;
    private final boolean securityOverriden;
    private final Set<String> determinedProjects;

    public QueryCreationContextImpl(ApplicationUser user) {
        this(user, false);
    }

    public QueryCreationContextImpl(ApplicationUser user, boolean securityOverriden) {
        this(user, securityOverriden, Collections.emptySet());
    }

    public QueryCreationContextImpl(QueryCreationContext queryCreationContext, Set<String> determinedProjects) {
        this(queryCreationContext.getApplicationUser(), queryCreationContext.isSecurityOverriden(), determinedProjects);
    }

    public QueryCreationContextImpl(ApplicationUser user, boolean securityOverriden, Set<String> determinedProjects) {
        Assertions.notNull(determinedProjects);
        this.user = user;
        this.securityOverriden = securityOverriden;
        this.determinedProjects = determinedProjects;
    }

    @Override
    public ApplicationUser getApplicationUser() {
        return this.user;
    }

    @Override
    public ApplicationUser getUser() {
        return this.user;
    }

    @Override
    public ApplicationUser getQueryUser() {
        return this.user;
    }

    @Override
    public boolean isSecurityOverriden() {
        return this.securityOverriden;
    }

    @Override
    @Nonnull
    public Set<String> getDeterminedProjects() {
        return this.determinedProjects;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryCreationContextImpl that = (QueryCreationContextImpl)o;
        if (this.securityOverriden != that.securityOverriden) {
            return false;
        }
        if (!this.determinedProjects.equals(that.determinedProjects)) {
            return false;
        }
        return !(this.user != null ? !this.user.equals(that.user) : that.user != null);
    }

    public int hashCode() {
        int result = this.user != null ? this.user.hashCode() : 0;
        result = 31 * result + (this.securityOverriden ? 1 : 0);
        result = 31 * result + this.determinedProjects.hashCode();
        return result;
    }

    public String toString() {
        return "QueryCreationContextImpl{user=" + this.user + ", securityOverriden=" + this.securityOverriden + ", determinedProjects=" + this.determinedProjects + '}';
    }
}

