/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.entity.property;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.entity.WithId;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyHelper;
import com.atlassian.jira.entity.property.EntityPropertyOptions;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.entity.property.FieldTooLongJsonPropertyException;
import com.atlassian.jira.entity.property.InvalidJsonPropertyException;
import com.atlassian.jira.entity.property.JsonEntityPropertyManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class BaseEntityPropertyService<E extends WithId>
implements EntityPropertyService<E> {
    private final EntityPropertyHelper<E> entityPropertyHelper;
    private final EventPublisher eventPublisher;
    private final I18nHelper i18n;
    private final JsonEntityPropertyManager jsonEntityPropertyManager;
    private final String dbEntityName;

    public BaseEntityPropertyService(JsonEntityPropertyManager jsonEntityPropertyManager, I18nHelper i18n, EventPublisher eventPublisher, EntityPropertyHelper<E> entityPropertyHelper) {
        this.jsonEntityPropertyManager = jsonEntityPropertyManager;
        this.i18n = i18n;
        this.eventPublisher = eventPublisher;
        this.dbEntityName = entityPropertyHelper.getEntityPropertyType().getDbEntityName();
        this.entityPropertyHelper = entityPropertyHelper;
    }

    @Override
    public EntityPropertyService.SetPropertyValidationResult validateSetProperty(ApplicationUser user, Long entityId, EntityPropertyService.PropertyInput propertyInput) {
        return this.validateSetProperty(user, this.getEntity(entityId), propertyInput, EntityPropertyOptions.defaults());
    }

    @Override
    public EntityPropertyService.SetPropertyValidationResult validateSetProperty(ApplicationUser user, @Nonnull Long entityId, @Nonnull EntityPropertyService.PropertyInput propertyInput, @Nonnull EntityPropertyOptions options) {
        return this.validateSetProperty(null, this.getEntity(entityId), propertyInput, options);
    }

    protected EntityPropertyService.SetPropertyValidationResult validateSetProperty(ApplicationUser user, Option<E> entity, EntityPropertyService.PropertyInput propertyInput, EntityPropertyOptions options) {
        Preconditions.checkNotNull((Object)propertyInput);
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (this.checkEntity(entity, user, this.getEditPermissionFunction(options), errorCollection)) {
            if (StringUtils.isEmpty((CharSequence)propertyInput.getPropertyValue())) {
                errorCollection.addErrorMessage(this.i18n.getText("jira.properties.service.empty.value"), ErrorCollection.Reason.VALIDATION_FAILED);
            } else {
                errorCollection.addErrorCollection(this.validatePropertyInput(propertyInput));
            }
        }
        Option property = errorCollection.hasAnyErrors() ? Option.none() : Option.some((Object)this.createInputForPropertySet((WithId)entity.get(), propertyInput));
        return new EntityPropertyService.SetPropertyValidationResult((ErrorCollection)errorCollection, (Option<EntityPropertyService.EntityPropertyInput>)property);
    }

    @Override
    public ErrorCollection validatePropertyInput(EntityPropertyService.PropertyInput propertyInput) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        try {
            this.jsonEntityPropertyManager.putDryRun(this.dbEntityName, propertyInput.getPropertyKey(), propertyInput.getPropertyValue());
        }
        catch (InvalidJsonPropertyException ex) {
            errorCollection.addErrorMessage(this.i18n.getText("jira.properties.service.invalid.json", propertyInput.getPropertyValue()), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        catch (FieldTooLongJsonPropertyException ex) {
            errorCollection.addErrorMessage(this.i18n.getText("jira.properties.service.too.long.value", String.valueOf(ex.getMaximumLength()), String.valueOf(ex.getActualLength())), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        return errorCollection;
    }

    @Override
    public EntityPropertyService.PropertyResult setProperty(ApplicationUser user, @Nonnull EntityPropertyService.SetPropertyValidationResult propertyValidationResult) {
        Preconditions.checkNotNull((Object)propertyValidationResult);
        Preconditions.checkNotNull(propertyValidationResult.getEntityPropertyInput());
        Preconditions.checkArgument((boolean)propertyValidationResult.isValid());
        Preconditions.checkArgument((boolean)propertyValidationResult.getEntityPropertyInput().isDefined());
        EntityPropertyService.EntityPropertyInput entityProperty = (EntityPropertyService.EntityPropertyInput)propertyValidationResult.getEntityPropertyInput().get();
        this.jsonEntityPropertyManager.put(user, this.dbEntityName, entityProperty.getEntityId(), entityProperty.getPropertyKey(), entityProperty.getPropertyValue(), this.entityPropertyHelper.createSetPropertyEventBiFunction(), true);
        return this.getProperty(user, entityProperty.getEntityId(), entityProperty.getPropertyKey());
    }

    @Override
    public EntityPropertyService.DeletePropertyValidationResult validateDeleteProperty(ApplicationUser user, Long entityId, String propertyKey) {
        return this.validateDeleteProperty(user, this.getEntity(entityId), propertyKey, EntityPropertyOptions.defaults());
    }

    @Override
    public EntityPropertyService.DeletePropertyValidationResult validateDeleteProperty(ApplicationUser user, @Nonnull Long entityId, @Nonnull String propertyKey, @Nonnull EntityPropertyOptions options) {
        return this.validateDeleteProperty(null, this.getEntity(entityId), propertyKey, options);
    }

    protected EntityPropertyService.DeletePropertyValidationResult validateDeleteProperty(ApplicationUser user, Option<E> entity, @Nonnull String propertyKey, @Nonnull EntityPropertyOptions options) {
        Preconditions.checkNotNull((Object)propertyKey);
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (this.checkEntity(entity, user, this.getEditPermissionFunction(options), errorCollection)) {
            EntityPropertyService.PropertyResult property = this.getProperty(user, entity, propertyKey, options);
            return (EntityPropertyService.DeletePropertyValidationResult)property.getEntityProperty().fold(() -> {
                errorCollection.addErrorMessage(this.i18n.getText("jira.properties.service.property.does.not.exist", propertyKey), ErrorCollection.Reason.NOT_FOUND);
                return new EntityPropertyService.DeletePropertyValidationResult((ErrorCollection)errorCollection, (Option<EntityProperty>)Option.none());
            }, entityProperty -> new EntityPropertyService.DeletePropertyValidationResult((ErrorCollection)errorCollection, (Option<EntityProperty>)Option.some((Object)entityProperty)));
        }
        return new EntityPropertyService.DeletePropertyValidationResult((ErrorCollection)errorCollection, (Option<EntityProperty>)Option.none());
    }

    @Override
    public void deleteProperty(ApplicationUser user, @Nonnull EntityPropertyService.DeletePropertyValidationResult validationResult) {
        Preconditions.checkNotNull((Object)validationResult);
        Preconditions.checkArgument((boolean)validationResult.isValid());
        Preconditions.checkNotNull(validationResult.getEntityProperty());
        Preconditions.checkArgument((boolean)validationResult.getEntityProperty().isDefined());
        EntityProperty entityProperty = (EntityProperty)validationResult.getEntityProperty().get();
        this.jsonEntityPropertyManager.delete(this.dbEntityName, entityProperty.getEntityId(), entityProperty.getKey());
        this.eventPublisher.publish((Object)this.entityPropertyHelper.createDeletePropertyEventBiFunction().apply(user, entityProperty));
    }

    @Override
    public EntityPropertyService.PropertyResult getProperty(ApplicationUser user, Long entityId, String propertyKey) {
        return this.getProperty(user, this.getEntity(entityId), propertyKey, EntityPropertyOptions.defaults());
    }

    @Override
    public EntityPropertyService.PropertyResult getProperty(ApplicationUser user, @Nonnull Long entityId, @Nonnull String propertyKey, @Nonnull EntityPropertyOptions options) {
        return this.getProperty((ApplicationUser)null, this.getEntity(entityId), propertyKey, options);
    }

    @Override
    public List<EntityProperty> getProperties(ApplicationUser user, Long entityId, List<String> propertyKeys) {
        return this.getProperties(user, entityId, (Supplier<Map<String, EntityProperty>>)((Supplier)() -> this.jsonEntityPropertyManager.get(this.entityPropertyHelper.getEntityPropertyType().getDbEntityName(), entityId, propertyKeys)));
    }

    @Override
    public List<EntityProperty> getProperties(ApplicationUser user, Long entityId) {
        return this.getProperties(user, entityId, (Supplier<Map<String, EntityProperty>>)((Supplier)() -> this.jsonEntityPropertyManager.get(this.entityPropertyHelper.getEntityPropertyType().getDbEntityName(), entityId)));
    }

    private List<EntityProperty> getProperties(ApplicationUser user, Long entityId, Supplier<Map<String, EntityProperty>> loader) {
        WithId entity = (WithId)this.getEntity(entityId).getOrNull();
        if (entity == null || ((ErrorCollection)this.entityPropertyHelper.hasReadPermissionFunction().apply(user, entity)).hasAnyErrors()) {
            return Collections.emptyList();
        }
        Map fromDb = (Map)loader.get();
        return fromDb != null ? ImmutableList.copyOf(fromDb.values()) : Collections.emptyList();
    }

    @Override
    public EntityPropertyService.PropertyResult getProperty(ApplicationUser user, @Nonnull E entity, @Nonnull String propertyKey, @Nonnull EntityPropertyOptions options) {
        return this.getProperty(user, Option.some(entity), propertyKey, options);
    }

    @Override
    protected EntityPropertyService.PropertyResult getProperty(ApplicationUser user, Option<E> entity, @Nonnull String propertyKey, EntityPropertyOptions options) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (this.checkEntity(entity, user, this.getReadPermissionFunction(options), errorCollection)) {
            EntityProperty entityProperty = this.jsonEntityPropertyManager.get(this.dbEntityName, ((WithId)entity.get()).getId(), propertyKey);
            return new EntityPropertyService.PropertyResult((ErrorCollection)errorCollection, (Option<EntityProperty>)Option.option((Object)entityProperty));
        }
        return new EntityPropertyService.PropertyResult((ErrorCollection)errorCollection, (Option<EntityProperty>)Option.none());
    }

    @Override
    public EntityPropertyService.PropertyKeys<E> getPropertiesKeys(ApplicationUser user, Long entityId) {
        return this.getPropertiesKeys(user, this.getEntity(entityId), EntityPropertyOptions.defaults());
    }

    @Override
    public EntityPropertyService.PropertyKeys<E> getPropertiesKeys(ApplicationUser user, @Nonnull Long entityId, @Nonnull EntityPropertyOptions options) {
        return this.getPropertiesKeys(user, this.getEntity(entityId), options);
    }

    protected EntityPropertyService.PropertyKeys<E> getPropertiesKeys(ApplicationUser user, Option<E> entity, EntityPropertyOptions options) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (this.checkEntity(entity, user, this.getReadPermissionFunction(options), errorCollection)) {
            List<String> keys = this.jsonEntityPropertyManager.findKeys(this.dbEntityName, ((WithId)entity.get()).getId());
            return new EntityPropertyService.PropertyKeys<Object>(errorCollection, keys, entity.get());
        }
        return new EntityPropertyService.PropertyKeys<Object>(errorCollection, Collections.emptyList(), null);
    }

    private boolean checkEntity(Option<E> entity, ApplicationUser user, EntityPropertyHelper.CheckPermissionFunction<E> permissionFunction, SimpleErrorCollection errorCollection) {
        return (Boolean)entity.fold(() -> {
            errorCollection.addErrorMessage(this.i18n.getText("jira.properties.service.entity.does.not.exist", this.i18n.getText(this.entityPropertyHelper.getEntityPropertyType().getI18nKeyForEntityName())), ErrorCollection.Reason.NOT_FOUND);
            return false;
        }, input -> {
            ErrorCollection permissionCheckResults = (ErrorCollection)permissionFunction.apply(user, input);
            if (permissionCheckResults.hasAnyErrors()) {
                errorCollection.addErrorCollection(permissionCheckResults);
            }
            return !permissionCheckResults.hasAnyErrors();
        });
    }

    private EntityPropertyService.EntityPropertyInput createInputForPropertySet(E entity, EntityPropertyService.PropertyInput propertyInput) {
        return new EntityPropertyService.EntityPropertyInput(propertyInput.getPropertyValue(), propertyInput.getPropertyKey(), entity.getId(), this.dbEntityName);
    }

    private Option<E> getEntity(Long entityId) {
        return this.entityPropertyHelper.getEntityByIdFunction().apply(entityId);
    }

    private EntityPropertyHelper.CheckPermissionFunction<E> getReadPermissionFunction(EntityPropertyOptions options) {
        if (options.skipPermissionChecks()) {
            return new NoPermissionCheckFunction();
        }
        return this.entityPropertyHelper.hasReadPermissionFunction();
    }

    private EntityPropertyHelper.CheckPermissionFunction<E> getEditPermissionFunction(EntityPropertyOptions options) {
        if (options.skipPermissionChecks()) {
            return new NoPermissionCheckFunction();
        }
        return this.entityPropertyHelper.hasEditPermissionFunction();
    }

    private class NoPermissionCheckFunction
    implements EntityPropertyHelper.CheckPermissionFunction<E> {
        private NoPermissionCheckFunction() {
        }

        @Override
        public ErrorCollection apply(ApplicationUser user, E e) {
            return new SimpleErrorCollection();
        }
    }
}

