/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics;

import com.atlassian.jira.datetime.LocalDate;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import java.util.Comparator;

public class LocalDateFieldSorter
implements LuceneFieldSorter<LocalDate> {
    private static final Comparator<LocalDate> SIMPLE_COMPARATOR = new SimpleLocalDateComparator();
    private final String documentConstant;

    public LocalDateFieldSorter(String documentConstant) {
        this.documentConstant = documentConstant;
    }

    @Override
    public String getDocumentConstant() {
        return this.documentConstant;
    }

    @Override
    public LocalDate getValueFromLuceneField(String documentValue) {
        if (documentValue == null) {
            return null;
        }
        return new LocalDate(Long.parseLong(documentValue));
    }

    @Override
    public Comparator<LocalDate> getComparator() {
        return SIMPLE_COMPARATOR;
    }

    private static class SimpleLocalDateComparator
    implements Comparator<LocalDate> {
        private SimpleLocalDateComparator() {
        }

        @Override
        public int compare(LocalDate o1, LocalDate o2) {
            return o1.compareTo(o2);
        }
    }
}

