/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.worklog;

import com.atlassian.jira.bc.issue.visibility.Visibilities;
import com.atlassian.jira.bc.issue.visibility.Visibility;
import com.atlassian.jira.bc.issue.worklog.WorklogAdjustmentAmountInputParameters;
import com.atlassian.jira.bc.issue.worklog.WorklogInputParameters;
import com.atlassian.jira.bc.issue.worklog.WorklogNewEstimateInputParameters;
import com.atlassian.jira.issue.Issue;
import java.util.Date;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class WorklogInputParametersImpl
implements WorklogInputParameters,
WorklogNewEstimateInputParameters,
WorklogAdjustmentAmountInputParameters {
    private final Long worklogId;
    private final Issue issue;
    private final String timeSpent;
    private final Date startDate;
    private final String comment;
    private final String groupLevel;
    private final String roleLevelId;
    private final Visibility visibility;
    private final String newEstimate;
    private final String adjustmentAmount;
    private final boolean editableCheckRequired;
    private final String errorFieldPrefix;

    private WorklogInputParametersImpl(Long worklogId, Issue issue, String timeSpent, Date startDate, String comment, String groupLevel, String roleLevelId, Visibility visibility, String newEstimate, String adjustmentAmount, boolean editableCheckRequired, String errorFieldPrefix) {
        this.adjustmentAmount = adjustmentAmount;
        this.comment = comment;
        this.editableCheckRequired = editableCheckRequired;
        this.issue = issue;
        this.newEstimate = newEstimate;
        this.groupLevel = groupLevel;
        this.roleLevelId = roleLevelId;
        this.visibility = visibility;
        this.startDate = startDate;
        this.timeSpent = timeSpent;
        this.worklogId = worklogId;
        this.errorFieldPrefix = errorFieldPrefix;
    }

    @Override
    public Long getWorklogId() {
        return this.worklogId;
    }

    @Override
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public String getTimeSpent() {
        return this.timeSpent;
    }

    @Override
    public Date getStartDate() {
        return this.startDate;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    @Deprecated
    public String getGroupLevel() {
        return this.groupLevel;
    }

    @Override
    @Deprecated
    public String getRoleLevelId() {
        return this.roleLevelId;
    }

    @Override
    public Visibility getVisibility() {
        return this.visibility;
    }

    @Override
    public String getNewEstimate() {
        return this.newEstimate;
    }

    @Override
    public String getAdjustmentAmount() {
        return this.adjustmentAmount;
    }

    @Override
    public boolean isEditableCheckRequired() {
        return this.editableCheckRequired;
    }

    @Override
    public String getErrorFieldPrefix() {
        return this.errorFieldPrefix;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder issue(Issue issue) {
        return new Builder().issue(issue);
    }

    public static Builder timeSpent(String timeSpent) {
        return new Builder().timeSpent(timeSpent);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorklogInputParametersImpl rhs = (WorklogInputParametersImpl)o;
        return new EqualsBuilder().append((Object)this.worklogId, (Object)rhs.worklogId).append((Object)this.issue, (Object)rhs.issue).append((Object)this.timeSpent, (Object)rhs.timeSpent).append((Object)this.startDate, (Object)rhs.startDate).append((Object)this.comment, (Object)rhs.comment).append((Object)this.visibility, (Object)rhs.visibility).append((Object)this.newEstimate, (Object)rhs.newEstimate).append((Object)this.adjustmentAmount, (Object)rhs.adjustmentAmount).append(this.editableCheckRequired, rhs.editableCheckRequired).append((Object)this.errorFieldPrefix, (Object)rhs.errorFieldPrefix).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(11, 29).append((Object)this.worklogId).append((Object)this.issue).append((Object)this.timeSpent).append((Object)this.startDate).append((Object)this.comment).append((Object)this.visibility).append((Object)this.newEstimate).append((Object)this.adjustmentAmount).append(this.editableCheckRequired).append((Object)this.errorFieldPrefix).toHashCode();
    }

    public static class Builder {
        private Long worklogId = null;
        private Issue issue = null;
        private String timeSpent = null;
        private Date startDate = null;
        private String comment = null;
        private String groupLevel = null;
        private String roleLevelId = null;
        private Visibility visibility = null;
        private String newEstimate = null;
        private String adjustmentAmount = null;
        private boolean editableCheckRequired = true;
        private String errorFieldPrefix = null;

        public Builder worklogId(Long worklogId) {
            this.worklogId = worklogId;
            return this;
        }

        public Builder issue(Issue issue) {
            this.issue = issue;
            return this;
        }

        public Builder timeSpent(String timeSpent) {
            this.timeSpent = timeSpent;
            return this;
        }

        public Builder startDate(Date startDate) {
            this.startDate = startDate;
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        @Deprecated
        public Builder groupLevel(String groupLevel) {
            this.groupLevel = groupLevel;
            return this;
        }

        @Deprecated
        public Builder roleLevelId(String roleLevelId) {
            this.roleLevelId = roleLevelId;
            return this;
        }

        public Builder visibility(Visibility visibility) {
            this.visibility = visibility;
            return this;
        }

        public Builder newEstimate(String newEstimate) {
            this.newEstimate = newEstimate;
            return this;
        }

        public Builder adjustmentAmount(String adjustmentAmount) {
            this.adjustmentAmount = adjustmentAmount;
            return this;
        }

        public Builder editableCheckRequired(boolean editableCheckRequired) {
            this.editableCheckRequired = editableCheckRequired;
            return this;
        }

        public Builder errorFieldPrefix(String errorFieldPrefix) {
            this.errorFieldPrefix = errorFieldPrefix;
            return this;
        }

        public WorklogInputParameters build() {
            return new WorklogInputParametersImpl(this.worklogId, this.issue, this.timeSpent, this.startDate, this.comment, this.groupLevel, this.roleLevelId, this.getVisibility(), null, null, this.editableCheckRequired, this.errorFieldPrefix);
        }

        public WorklogInputParameters buildAll() {
            return new WorklogInputParametersImpl(this.worklogId, this.issue, this.timeSpent, this.startDate, this.comment, this.groupLevel, this.roleLevelId, this.getVisibility(), this.newEstimate, this.adjustmentAmount, this.editableCheckRequired, this.errorFieldPrefix);
        }

        public WorklogNewEstimateInputParameters buildNewEstimate() {
            return new WorklogInputParametersImpl(this.worklogId, this.issue, this.timeSpent, this.startDate, this.comment, this.groupLevel, this.roleLevelId, this.getVisibility(), this.newEstimate, null, this.editableCheckRequired, this.errorFieldPrefix);
        }

        public WorklogAdjustmentAmountInputParameters buildAdjustmentAmount() {
            return new WorklogInputParametersImpl(this.worklogId, this.issue, this.timeSpent, this.startDate, this.comment, this.groupLevel, this.roleLevelId, this.getVisibility(), null, this.adjustmentAmount, this.editableCheckRequired, this.errorFieldPrefix);
        }

        private Visibility getVisibility() {
            if (this.visibility == null) {
                return Visibilities.fromGroupAndStrRoleId(this.groupLevel, this.roleLevelId);
            }
            return this.visibility;
        }
    }
}

