/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.task.context;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.task.context.CompositeSink;
import com.atlassian.jira.task.context.JohnsonEventSink;
import com.atlassian.jira.task.context.LoggingContextSink;
import com.atlassian.jira.task.context.PercentageContext;
import com.atlassian.jira.task.context.Sink;
import com.atlassian.jira.task.context.TaskProgressPercentageContextSink;
import com.atlassian.jira.task.context.UnboundContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.FixedSized;
import com.atlassian.jira.util.collect.Sized;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.johnson.event.Event;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

@PublicApi
public interface Context {
    public void setName(String var1);

    public Task start(Object var1);

    public int getNumberOfTasksToCompletion();

    public static class Builder {
        private final Collection<Sink> sinks = new ArrayList<Sink>(4);
        private Sized sized = new FixedSized(0);

        public Builder sized(@Nonnull Sized sized) {
            this.sized = Assertions.notNull("sized", sized);
            return this;
        }

        private Builder sink(@Nonnull Sink sink) {
            this.sinks.add(Assertions.notNull("sink", sink));
            return this;
        }

        public Builder event(@Nonnull Event event) {
            return this.sink(new JohnsonEventSink(event));
        }

        public Builder log(@Nonnull Logger log, @Nonnull String format) {
            return this.sink(new LoggingContextSink(log, format, Level.DEBUG));
        }

        public Builder log(@Nonnull Logger log, @Nonnull String format, @Nonnull Level level) {
            return this.sink(new LoggingContextSink(log, format, level));
        }

        public Builder progress(@Nonnull TaskProgressSink progressSink, @Nonnull I18nHelper i18n, @Nonnull String uiMessageKeyPercentage, @Nullable String uiMessageKeyCurrent) {
            return this.sink(new TaskProgressPercentageContextSink(i18n, progressSink, uiMessageKeyPercentage, uiMessageKeyCurrent));
        }

        public Builder progressPercentage(@Nonnull TaskProgressSink progressSink, @Nonnull I18nHelper i18n, @Nullable String uiMessageKeyPercentage) {
            return this.sink(new TaskProgressPercentageContextSink(i18n, progressSink, uiMessageKeyPercentage, null));
        }

        public Builder progressSubTask(@Nonnull TaskProgressSink progressSink, @Nonnull I18nHelper i18n, @Nullable String uiMessageKeyCurrent) {
            return this.sink(new TaskProgressPercentageContextSink(i18n, progressSink, "", uiMessageKeyCurrent));
        }

        public Context build() {
            int size;
            CompositeSink sink = new CompositeSink(this.sinks);
            if (this.sized != null && (size = this.sized.size()) > 0) {
                return new PercentageContext(size, sink);
            }
            return new UnboundContext(sink);
        }
    }

    public static interface Task
    extends AutoCloseable {
        public void complete();

        @Override
        default public void close() throws Exception {
            this.complete();
        }
    }
}

