/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.type;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.opensymphony.util.TextUtils;
import org.ofbiz.core.entity.GenericValue;

@PublicApi
public class EventType {
    public static final Long ISSUE_CREATED_ID = 1L;
    public static final Long ISSUE_UPDATED_ID = 2L;
    public static final Long ISSUE_ASSIGNED_ID = 3L;
    public static final Long ISSUE_RESOLVED_ID = 4L;
    public static final Long ISSUE_CLOSED_ID = 5L;
    public static final Long ISSUE_COMMENTED_ID = 6L;
    public static final Long ISSUE_REOPENED_ID = 7L;
    public static final Long ISSUE_DELETED_ID = 8L;
    public static final Long ISSUE_MOVED_ID = 9L;
    public static final Long ISSUE_WORKLOGGED_ID = 10L;
    public static final Long ISSUE_WORKSTARTED_ID = 11L;
    public static final Long ISSUE_WORKSTOPPED_ID = 12L;
    public static final Long ISSUE_GENERICEVENT_ID = 13L;
    public static final Long ISSUE_COMMENT_EDITED_ID = 14L;
    public static final Long ISSUE_WORKLOG_UPDATED_ID = 15L;
    public static final Long ISSUE_WORKLOG_DELETED_ID = 16L;
    public static final Long ISSUE_COMMENT_DELETED_ID = 17L;
    public static final Long ISSUE_ARCHIVED_ID = 18L;
    public static final Long ISSUE_RESTORED_ID = 19L;
    public static final String JIRA_SYSTEM_EVENT_TYPE = "jira.system.event.type";
    public static final String EVENT_TYPE = "EventType";
    private final Long id;
    private final String name;
    private final String description;
    private final String type;
    private Long templateId;

    public EventType(String name, String description, Long templateId) {
        this(null, name, description, templateId);
    }

    public EventType(Long id, String name, String description, Long templateId) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.templateId = templateId;
        this.type = null;
    }

    public EventType(GenericValue eventTypeGV) {
        this.id = eventTypeGV.getLong("id");
        this.name = eventTypeGV.getString("name");
        this.description = eventTypeGV.getString("description");
        this.type = eventTypeGV.getString("type");
        this.templateId = eventTypeGV.getLong("templateId");
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getType() {
        return this.type;
    }

    public Long getTemplateId() {
        return this.templateId == null ? this.id : this.templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public boolean isSystemEventType() {
        return this.type != null && this.type.equals(JIRA_SYSTEM_EVENT_TYPE);
    }

    public String getNameKey() {
        return "event.type." + this.getName().replace(" ", "").toLowerCase() + ".name";
    }

    public String getDescKey() {
        return "event.type." + this.getName().replace(" ", "").toLowerCase() + ".desc";
    }

    public String getTranslatedName(ApplicationUser remoteUser) {
        String translatedName = this.getI18nBean(remoteUser).getText(this.getNameKey());
        return TextUtils.stringSet((String)translatedName) && !translatedName.equals(this.getNameKey()) ? translatedName : this.name;
    }

    public String translateName(ApplicationUser remoteUser) {
        return this.getTranslatedName(remoteUser);
    }

    public String getTranslatedDesc(ApplicationUser remoteUser) {
        String translatedDesc = this.getI18nBean(remoteUser).getText(this.getDescKey());
        return TextUtils.stringSet((String)translatedDesc) && !translatedDesc.equals(this.getDescKey()) ? translatedDesc : this.description;
    }

    public String translateDesc(ApplicationUser remoteUser) {
        return this.getTranslatedDesc(remoteUser);
    }

    private I18nHelper getI18nBean(ApplicationUser remoteUser) {
        return ComponentAccessor.getI18nHelperFactory().getInstance(remoteUser);
    }

    public String toString() {
        return "EventType{id=" + this.id + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", type='" + this.type + '\'' + ", templateId=" + this.templateId + '}';
    }
}

