/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.entity.property;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.entity.WithId;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyOptions;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Option;
import java.util.List;
import javax.annotation.Nonnull;

@PublicApi
public interface EntityPropertyService<T extends WithId> {
    public ErrorCollection validatePropertyInput(PropertyInput var1);

    public SetPropertyValidationResult validateSetProperty(ApplicationUser var1, @Nonnull Long var2, @Nonnull PropertyInput var3);

    public SetPropertyValidationResult validateSetProperty(ApplicationUser var1, @Nonnull Long var2, @Nonnull PropertyInput var3, @Nonnull EntityPropertyOptions var4);

    public PropertyResult setProperty(ApplicationUser var1, @Nonnull SetPropertyValidationResult var2);

    public DeletePropertyValidationResult validateDeleteProperty(ApplicationUser var1, @Nonnull Long var2, @Nonnull String var3);

    public DeletePropertyValidationResult validateDeleteProperty(ApplicationUser var1, @Nonnull Long var2, @Nonnull String var3, @Nonnull EntityPropertyOptions var4);

    public void deleteProperty(ApplicationUser var1, @Nonnull DeletePropertyValidationResult var2);

    public PropertyResult getProperty(ApplicationUser var1, @Nonnull Long var2, @Nonnull String var3);

    public PropertyResult getProperty(ApplicationUser var1, @Nonnull Long var2, @Nonnull String var3, @Nonnull EntityPropertyOptions var4);

    public List<EntityProperty> getProperties(ApplicationUser var1, Long var2, List<String> var3);

    public List<EntityProperty> getProperties(ApplicationUser var1, Long var2);

    public PropertyKeys<T> getPropertiesKeys(ApplicationUser var1, @Nonnull Long var2);

    public PropertyKeys<T> getPropertiesKeys(ApplicationUser var1, @Nonnull Long var2, @Nonnull EntityPropertyOptions var3);

    @PublicApi
    public static class PropertyInput {
        private final String entityPropertyValue;
        private final String entityPropertyKey;

        public PropertyInput(String value, String key) {
            this.entityPropertyValue = (String)Preconditions.checkNotNull((Object)value);
            this.entityPropertyKey = (String)Preconditions.checkNotNull((Object)key);
        }

        @Nonnull
        public String getPropertyValue() {
            return this.entityPropertyValue;
        }

        @Nonnull
        public String getPropertyKey() {
            return this.entityPropertyKey;
        }
    }

    @PublicApi
    public static class EntityPropertyInput
    extends PropertyInput {
        private final Long id;
        private final String entityName;

        public EntityPropertyInput(String value, String key, Long id, String entityName) {
            super(value, key);
            this.id = id;
            this.entityName = entityName;
        }

        public Long getEntityId() {
            return this.id;
        }

        public String getEntityName() {
            return this.entityName;
        }
    }

    @PublicApi
    public static class DeletePropertyValidationResult
    extends PropertyServiceResult {
        public DeletePropertyValidationResult(ErrorCollection errorCollection, Option<EntityProperty> entityProperty) {
            super(errorCollection, entityProperty);
        }
    }

    @PublicApi
    public static class SetPropertyValidationResult
    extends ServiceResultImpl {
        private final Option<EntityPropertyInput> entityPropertyInput;

        public SetPropertyValidationResult(ErrorCollection errorCollection, Option<EntityPropertyInput> entityPropertyInput) {
            super(errorCollection);
            this.entityPropertyInput = entityPropertyInput;
        }

        public Option<EntityPropertyInput> getEntityPropertyInput() {
            return this.entityPropertyInput;
        }
    }

    @PublicApi
    public static class PropertyResult
    extends PropertyServiceResult {
        public PropertyResult(ErrorCollection errorCollection, Option<EntityProperty> entityProperty) {
            super(errorCollection, entityProperty);
        }
    }

    public static abstract class PropertyServiceResult
    extends ServiceResultImpl {
        private final Option<EntityProperty> entityProperty;

        public PropertyServiceResult(ErrorCollection errorCollection, Option<EntityProperty> entityProperty) {
            super(errorCollection);
            this.entityProperty = entityProperty;
        }

        public Option<EntityProperty> getEntityProperty() {
            return this.entityProperty;
        }
    }

    @PublicApi
    public static class PropertyKeys<E>
    extends ServiceResultImpl {
        private final List<String> keys;
        private final E entity;

        public PropertyKeys(ErrorCollection errorCollection, List<String> keys, E entity) {
            super(errorCollection);
            this.keys = ImmutableList.copyOf(keys);
            this.entity = entity;
        }

        public List<String> getKeys() {
            return this.keys;
        }

        public E getEntity() {
            return this.entity;
        }
    }
}

