/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharePermissionImpl;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.rights.ShareRight;
import com.atlassian.jira.sharing.rights.ShareRights;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicApi
public class SharePermissionUtils {
    private static final String TYPE_KEY = "type";
    private static final String PARAM1_KEY = "param1";
    private static final String PARAM2_KEY = "param2";
    private static final String RIGHTS_KEY = "rights";
    private static final String VALUE_KEY = "value";
    private static final Logger log = LoggerFactory.getLogger(SharePermissionUtils.class);

    public static JSONObject toJson(SharePermission permission) throws JSONException {
        Assertions.notNull("permission", permission);
        JSONObject object = new JSONObject();
        object.put(TYPE_KEY, permission.getType());
        object.put(RIGHTS_KEY, SharePermissionUtils.getShareRightsJson(permission.getRights()));
        if (permission.getParam1() != null) {
            object.put(PARAM1_KEY, permission.getParam1());
            if (permission.getParam2() != null) {
                object.put(PARAM2_KEY, permission.getParam2());
            }
        }
        return object;
    }

    public static JSONArray toJsonArray(Collection<SharePermission> permissions) throws JSONException {
        Assertions.notNull("permission", permissions);
        JSONArray array = new JSONArray();
        for (SharePermission sharePermission : permissions) {
            array.put(SharePermissionUtils.toJson(sharePermission));
        }
        return array;
    }

    public static SharePermission fromJsonObject(JSONObject json) throws JSONException {
        ShareRight rights;
        ShareType.Name type;
        Assertions.notNull("json", json);
        if (!json.has(TYPE_KEY)) {
            throw new JSONException("Invalid JSON SharePermission: No type passed.");
        }
        try {
            type = new ShareType.Name(json.getString(TYPE_KEY));
        }
        catch (IllegalArgumentException e) {
            throw new JSONException(e);
        }
        try {
            rights = ShareRightUtils.fromValue(json.getJSONObject(RIGHTS_KEY).getInt(VALUE_KEY));
        }
        catch (JSONException e) {
            rights = ShareRights.VIEW;
            log.warn("Rights object could not be found in the Share Permission JSON. Right to 'view' will be assigned as default.", (Throwable)e);
        }
        String param1 = null;
        String param2 = null;
        if (json.has(PARAM1_KEY)) {
            param1 = json.getString(PARAM1_KEY);
            if (StringUtils.isBlank((CharSequence)param1)) {
                throw new JSONException("Invalid JSON SharePermission: 'param1' cannot be blank.");
            }
            if (json.has(PARAM2_KEY) && StringUtils.isBlank((CharSequence)(param2 = json.getString(PARAM2_KEY)))) {
                throw new JSONException("Invalid JSON SharePermission: 'param2' cannot be blank.");
            }
        } else if (json.has(PARAM2_KEY)) {
            throw new JSONException("Invalid JSON SharePermission: 'param2' passed without 'param1'.");
        }
        return new SharePermissionImpl(type, param1, param2, rights);
    }

    public static SharePermission fromJsonObjectString(String jsonString) throws JSONException {
        Assertions.notNull("jsonString", jsonString);
        if (StringUtils.isBlank((CharSequence)jsonString)) {
            return null;
        }
        return SharePermissionUtils.fromJsonObject(new JSONObject(jsonString));
    }

    public static SharedEntity.SharePermissions fromJsonArray(JSONArray array) throws JSONException {
        Assertions.notNull("array", array);
        HashSet<SharePermission> permissions = new HashSet<SharePermission>(array.length());
        for (int i = 0; i < array.length(); ++i) {
            permissions.add(SharePermissionUtils.fromJsonObject(array.getJSONObject(i)));
        }
        return new SharedEntity.SharePermissions(permissions);
    }

    public static SharedEntity.SharePermissions fromJsonArrayString(String jsonString) throws JSONException {
        Assertions.notNull("jsonString", jsonString);
        if (StringUtils.isBlank((CharSequence)jsonString)) {
            return SharedEntity.SharePermissions.PRIVATE;
        }
        return SharePermissionUtils.fromJsonArray(new JSONArray(jsonString));
    }

    private SharePermissionUtils() {
    }

    public static JSONObject getShareRightsJson(ShareRight shareRight) throws JSONException {
        return new JSONObject().put(VALUE_KEY, ShareRightUtils.getIntegerValueFromShareRight(shareRight));
    }

    @ExperimentalApi
    public static class ShareRightUtils {
        private ShareRightUtils() {
        }

        public static int getIntegerValueFromShareRight(@Nullable ShareRight shareRight) {
            if (shareRight == null) {
                return Constants.VIEW_MASK;
            }
            int retVal = 0;
            if (shareRight.hasViewRightsGranted()) {
                retVal = Constants.VIEW_MASK;
            }
            if (shareRight.hasEditRightsGranted()) {
                retVal |= Constants.EDIT_MASK;
            }
            return retVal;
        }

        public static ShareRight fromValue(@Nullable Integer value) {
            if (value == null || value < 0) {
                return ShareRights.VIEW;
            }
            if ((value & Constants.EDIT_MASK) > 0 && (value & Constants.VIEW_MASK) > 0) {
                return ShareRights.VIEW_EDIT;
            }
            return ShareRights.VIEW;
        }

        public static ShareRight fromBooleans(boolean isView, boolean isEdit) {
            if (isEdit && isView) {
                return ShareRights.VIEW_EDIT;
            }
            return ShareRights.VIEW;
        }

        private static class Constants {
            private static int VIEW_MASK = 1;
            private static int EDIT_MASK = 2;

            private Constants() {
            }
        }
    }
}

