/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project;

import com.atlassian.jira.util.dbc.Assertions;
import io.atlassian.fugue.Option;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class UpdateProjectParameters {
    private final Long projectId;
    private Option<String> key = Option.none();
    private Option<String> name = Option.none();
    private Option<String> description = Option.none();
    private Option<String> leadUserKey = Option.none();
    private Option<String> leadUsername = Option.none();
    private Option<String> url = Option.none();
    private Option<Long> assigneeType = Option.none();
    private Option<Long> avatarId = Option.none();
    private Option<String> projectTypeKey = Option.none();
    private Option<Long> projectCategoryId = Option.none();

    public static UpdateProjectParameters forProject(Long projectId) {
        return new UpdateProjectParameters(projectId);
    }

    private UpdateProjectParameters(Long projectId) {
        this.projectId = Assertions.notNull(projectId);
    }

    public UpdateProjectParameters key(String key) {
        this.key = Option.option((Object)key);
        return this;
    }

    public UpdateProjectParameters name(String name) {
        this.name = Option.option((Object)name);
        return this;
    }

    public UpdateProjectParameters description(String description) {
        this.description = Option.option((Object)description);
        return this;
    }

    public UpdateProjectParameters leadUserKey(String leadUserKey) {
        this.leadUserKey = Option.option((Object)leadUserKey);
        return this;
    }

    public UpdateProjectParameters leadUsername(String leadUsername) {
        this.leadUsername = Option.option((Object)leadUsername);
        return this;
    }

    public UpdateProjectParameters url(String url) {
        this.url = Option.option((Object)url);
        return this;
    }

    public UpdateProjectParameters assigneeType(Long assigneeType) {
        this.assigneeType = Option.option((Object)assigneeType);
        return this;
    }

    public UpdateProjectParameters avatarId(Long avatarId) {
        this.avatarId = Option.option((Object)avatarId);
        return this;
    }

    public UpdateProjectParameters projectType(String projectType) {
        this.projectTypeKey = Option.option((Object)projectType);
        return this;
    }

    public UpdateProjectParameters projectCategoryId(Long projectCategoryId) {
        this.projectCategoryId = Option.option((Object)projectCategoryId);
        return this;
    }

    public Option<String> getKey() {
        return this.key;
    }

    public Option<String> getName() {
        return this.name;
    }

    public Option<String> getDescription() {
        return this.description;
    }

    public Option<String> getLeadUserKey() {
        return this.leadUserKey;
    }

    public Option<String> getLeadUsername() {
        return this.leadUsername;
    }

    public Option<String> getUrl() {
        return this.url;
    }

    public Option<Long> getAssigneeType() {
        return this.assigneeType;
    }

    public Option<Long> getAvatarId() {
        return this.avatarId;
    }

    public Option<String> getProjectTypeKey() {
        return this.projectTypeKey;
    }

    public Option<Long> getProjectCategoryId() {
        return this.projectCategoryId;
    }

    public Long getProjectId() {
        return this.projectId;
    }
}

