/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.query.clause;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.index.IndexDocumentConfiguration;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.text.MessageFormat;
import java.util.List;

@ExperimentalApi
public class Property {
    public static final Function<String, List<String>> SPLIT_STRING = new Function<String, List<String>>(){

        public List<String> apply(String input) {
            return ImmutableList.copyOf((Object[])input.split("\\."));
        }
    };
    private static final Joiner joiner = Joiner.on((char)'.');
    private final List<String> keys;
    private final List<String> objectReferences;
    private final IndexDocumentConfiguration.Type type;

    public Property(List<String> keys, List<String> objectReferences) {
        this(keys, objectReferences, null);
    }

    public Property(List<String> keys, List<String> objectReferences, IndexDocumentConfiguration.Type type) {
        this.keys = ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)Iterables.transform(keys, SPLIT_STRING)));
        this.objectReferences = ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)Iterables.transform(objectReferences, SPLIT_STRING)));
        this.type = type;
    }

    public List<String> getKeys() {
        return this.keys;
    }

    public List<String> getObjectReferences() {
        return this.objectReferences;
    }

    public IndexDocumentConfiguration.Type getType() {
        return this.type;
    }

    public String getAsPropertyString() {
        return MessageFormat.format("{0}${1}", this.getKeysAsString(), this.getObjectReferencesAsString());
    }

    public String getKeysAsString() {
        return joiner.join(this.keys);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.keys, this.objectReferences, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Property)) {
            return false;
        }
        Property property = (Property)obj;
        return Objects.equal(this.keys, property.keys) && Objects.equal(this.objectReferences, property.objectReferences) && Objects.equal((Object)((Object)this.type), (Object)((Object)property.type));
    }

    public String toString() {
        return String.format("[%s].%s", this.getKeysAsString(), this.getObjectReferencesAsString());
    }

    public String getObjectReferencesAsString() {
        return joiner.join(this.getObjectReferences());
    }
}

