/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.i18n.terminology;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.i18n.terminology.TerminologyEntry;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ExperimentalApi
@ParametersAreNonnullByDefault
public interface TerminologyEntryWriter {
    public TerminologyValidationResult validateAndPrepareTerminologyChange(String var1, String var2, String var3);

    public void changeTerminology(TerminologyValidationResult var1);

    @ExperimentalApi
    @ParametersAreNonnullByDefault
    @ReturnValuesAreNonnullByDefault
    public static class TerminologyValidationResult
    extends ServiceResultImpl {
        private final TerminologyEntry terminologyEntry;

        TerminologyValidationResult(@Nullable TerminologyEntry terminologyEntry, ErrorCollection errors) {
            super(errors);
            if (this.isValidEntryWithErrors(terminologyEntry, errors) || this.isInvalidEntryWithNoErrors(terminologyEntry, errors)) {
                throw new IllegalArgumentException(String.format("Result must be either valid with entry or invalid with errors. Current values: Entry - '%s', Errors - '%s'", terminologyEntry, errors));
            }
            this.terminologyEntry = terminologyEntry;
        }

        private boolean isValidEntryWithErrors(@Nullable TerminologyEntry terminologyEntry, ErrorCollection errors) {
            return terminologyEntry != null && errors.hasAnyErrors();
        }

        private boolean isInvalidEntryWithNoErrors(@Nullable TerminologyEntry terminologyEntry, ErrorCollection errors) {
            return terminologyEntry == null && !errors.hasAnyErrors();
        }

        static TerminologyValidationResult ok(TerminologyEntry terminologyEntry) {
            return new TerminologyValidationResult(terminologyEntry, new SimpleErrorCollection());
        }

        static TerminologyValidationResult error(ErrorCollection errors) {
            return new TerminologyValidationResult(null, errors);
        }

        @Nullable
        public TerminologyEntry getTerminologyEntry() {
            return this.terminologyEntry;
        }
    }
}

