/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.i18n.terminology;

import com.atlassian.jira.i18n.terminology.TerminologyEntry;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;

@ParametersAreNonnullByDefault
@Immutable
public final class TerminologyEntryChangedEvent {
    private final String originalName;
    private final String oldName;
    private final String oldNamePlural;
    private final String newName;
    private final String newNamePlural;

    public TerminologyEntryChangedEvent(Optional<TerminologyEntry> previousEntry, TerminologyEntry currentEntry) {
        this.originalName = currentEntry.getOriginalName();
        this.oldName = previousEntry.isPresent() ? previousEntry.get().getNewName() : this.originalName;
        this.oldNamePlural = previousEntry.isPresent() ? previousEntry.get().getNewNamePlural() : "";
        this.newName = currentEntry.getNewName();
        this.newNamePlural = currentEntry.getNewNamePlural();
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public String getNewName() {
        return this.newName;
    }

    public String getNewNamePlural() {
        return this.newNamePlural;
    }

    public String getOldName() {
        return this.oldName;
    }

    public String getOldNamePlural() {
        return this.oldNamePlural;
    }

    public String toString() {
        return "TerminologyEntryChangedEvent{originalName='" + this.originalName + '\'' + ", oldName='" + this.oldName + '\'' + ", oldNamePlural='" + this.oldNamePlural + '\'' + ", newName='" + this.newName + '\'' + ", newNamePlural='" + this.newNamePlural + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TerminologyEntryChangedEvent that = (TerminologyEntryChangedEvent)o;
        return this.originalName.equals(that.originalName) && this.oldName.equals(that.oldName) && this.oldNamePlural.equals(that.oldNamePlural) && this.newName.equals(that.newName) && this.newNamePlural.equals(that.newNamePlural);
    }

    public int hashCode() {
        return Objects.hash(this.originalName, this.oldName, this.oldNamePlural, this.newName, this.newNamePlural);
    }
}

