/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.ListOrderedMessageSetImpl;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operator.Operator;
import java.util.List;

abstract class ValuesExistValidator {
    private final JqlOperandResolver operandResolver;
    private final I18nHelper.BeanFactory beanFactory;
    private final MessageSet.Level level;

    ValuesExistValidator(JqlOperandResolver operandResolver, I18nHelper.BeanFactory beanFactory) {
        this(operandResolver, beanFactory, MessageSet.Level.ERROR);
    }

    ValuesExistValidator(JqlOperandResolver operandResolver, I18nHelper.BeanFactory beanFactory, MessageSet.Level level) {
        this.beanFactory = Assertions.notNull("beanFactory", beanFactory);
        this.operandResolver = Assertions.notNull("operandResolver", operandResolver);
        this.level = level;
    }

    MessageSet validate(TerminalClause terminalClause, QueryCreationContext queryCreationContext) {
        Operand operand = terminalClause.getOperand();
        List<QueryLiteral> rawOperandValues = this.operandResolver.getValues(queryCreationContext, operand, terminalClause);
        return this.validate(queryCreationContext.getApplicationUser(), terminalClause, rawOperandValues);
    }

    MessageSet validate(ApplicationUser searcher, TerminalClause terminalClause) {
        Operand operand = terminalClause.getOperand();
        List<QueryLiteral> rawOperandValues = this.operandResolver.getValues(searcher, operand, terminalClause);
        return this.validate(searcher, terminalClause, rawOperandValues);
    }

    private MessageSet validate(ApplicationUser searcher, TerminalClause terminalClause, List<QueryLiteral> rawOperandValues) {
        ListOrderedMessageSetImpl messages = new ListOrderedMessageSetImpl();
        if (this.operandResolver.isValidOperand(terminalClause.getOperand())) {
            for (QueryLiteral rawValue : rawOperandValues) {
                this.validateOperandValue(searcher, terminalClause, rawValue, messages);
            }
        }
        return messages;
    }

    private void validateOperandValue(ApplicationUser searcher, TerminalClause terminalClause, QueryLiteral rawOperandValue, MessageSet messages) {
        if (rawOperandValue.getStringValue() != null) {
            this.validateStringOperandValue(searcher, terminalClause, rawOperandValue, messages);
        } else if (rawOperandValue.getLongValue() != null) {
            this.validateLongOperandValue(searcher, terminalClause, rawOperandValue, messages);
        }
    }

    private void validateLongOperandValue(ApplicationUser searcher, TerminalClause terminalClause, QueryLiteral rawOperandValue, MessageSet messages) {
        if (!this.longValueExist(searcher, rawOperandValue.getLongValue())) {
            if (this.operandResolver.isFunctionOperand(rawOperandValue.getSourceOperand())) {
                messages.addMessage(this.level, this.getI18n(searcher).getText("jira.jql.clause.no.value.for.name.from.function", rawOperandValue.getSourceOperand().getName(), terminalClause.getName()));
            } else {
                messages.addMessage(this.level, this.getI18n(searcher).getText("jira.jql.clause.no.value.for.id", terminalClause.getName(), rawOperandValue.getLongValue().toString()));
            }
        }
    }

    private void validateStringOperandValue(ApplicationUser searcher, TerminalClause terminalClause, QueryLiteral rawOperandValue, MessageSet messages) {
        if (!this.stringValueExists(searcher, rawOperandValue.getStringValue())) {
            if (this.operandResolver.isFunctionOperand(rawOperandValue.getSourceOperand())) {
                messages.addMessage(this.level, this.getI18n(searcher).getText("jira.jql.clause.no.value.for.name.from.function", rawOperandValue.getSourceOperand().getName(), terminalClause.getName()));
            } else {
                messages.addMessage(this.level, this.getI18n(searcher).getText("jira.jql.clause.no.value.for.name", terminalClause.getName(), rawOperandValue.getStringValue()));
                if (Operator.EQUALS.equals((Object)terminalClause.getOperator()) && (rawOperandValue.getStringValue().contains("*") || rawOperandValue.getStringValue().contains("?"))) {
                    messages.addMessage(this.level, this.getI18n(searcher).getText("jira.jql.clause.use.contains.operator"));
                }
            }
        }
    }

    abstract boolean stringValueExists(ApplicationUser var1, String var2);

    abstract boolean longValueExist(ApplicationUser var1, Long var2);

    I18nHelper getI18n(ApplicationUser user) {
        return this.beanFactory.getInstance(user);
    }
}

