/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.web.component.Pager;
import com.atlassian.jira.web.component.ResultPage;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

@PublicApi
public class SearchResults<T>
implements Pager {
    private Collection<Page> pages;
    private static final int PAGES_TO_LIST = 5;
    private final int start;
    private final int max;
    private final int total;
    private final List<T> resultsInPage;

    public SearchResults(List<T> resultsInPage, int totalResultCount, int maxResultCount, int startIndex) {
        this.start = startIndex;
        this.total = totalResultCount;
        this.max = maxResultCount;
        this.resultsInPage = resultsInPage;
    }

    public <R> SearchResults<R> transform(Function<T, R> transformer) {
        return new SearchResults(this.resultsInPage.stream().map(transformer).collect(Collectors.toList()), this.total, this.max, this.start);
    }

    public List<T> getResults() {
        return Collections.unmodifiableList(this.resultsInPage);
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return Math.min(this.start + this.max, this.total);
    }

    @Override
    public int getTotal() {
        return this.total;
    }

    public int getMax() {
        return this.max;
    }

    @Override
    public int getNextStart() {
        return this.start + this.max;
    }

    @Override
    public int getPreviousStart() {
        return Math.max(0, this.start - this.max);
    }

    public int getNiceStart() {
        if (this.getResults() == null || this.getResults().size() == 0) {
            return 0;
        }
        return this.getStart() + 1;
    }

    @Override
    public List<Page> getPages() {
        if (this.pages == null) {
            this.pages = this.generatePages();
        }
        return this.restrictPages(this.pages, this.total);
    }

    private List<Page> generatePages() {
        if (this.total == 0) {
            return Collections.emptyList();
        }
        if (this.max <= 0) {
            throw new IllegalArgumentException("Results per page should be 1 or greater.");
        }
        ArrayList pages = Lists.newArrayListWithCapacity((int)this.total);
        int pageNumber = 1;
        for (int index = 0; index < this.total; index += this.max) {
            boolean isCurrentPage = this.start >= index && this.start < index + this.max;
            pages.add(new Page(index, pageNumber, isCurrentPage));
            ++pageNumber;
        }
        return pages;
    }

    private List<Page> restrictPages(Collection<Page> pages, int size) {
        ArrayList<Page> pagesToDisplay = new ArrayList<Page>(10);
        int firstpage = 1;
        int lastpage = firstpage + 5 + 5 - 2;
        int maxpage = (size + this.max - 1) / this.max;
        if (lastpage < maxpage) {
            int ourpage = this.getStart() / this.max + 1;
            if (ourpage - firstpage > 4) {
                lastpage = ourpage + 5 - 1;
                if (lastpage > maxpage) {
                    lastpage = maxpage;
                }
                firstpage = lastpage - 5 - 5 + 2;
            }
        } else if (lastpage > maxpage) {
            lastpage = maxpage;
        }
        int minstart = (firstpage - 1) * this.max;
        int maxstart = (lastpage - 1) * this.max;
        for (Page page : pages) {
            boolean smallerThanMax;
            if (page.getStart() > size) continue;
            boolean largerThanMin = page.getStart() >= minstart;
            boolean bl = smallerThanMax = page.getStart() <= maxstart;
            if (!largerThanMin || !smallerThanMax) continue;
            pagesToDisplay.add(page);
        }
        return pagesToDisplay;
    }

    static class Page
    implements ResultPage {
        private final int start;
        private final int pageNumber;
        private final boolean currentPage;

        public Page(int start, int pageNumber, boolean isCurrentPage) {
            this.start = start;
            this.pageNumber = pageNumber;
            this.currentPage = isCurrentPage;
        }

        @Override
        public boolean isCurrentPage() {
            return this.currentPage;
        }

        @Override
        public int getStart() {
            return this.start;
        }

        @Override
        public int getPageNumber() {
            return this.pageNumber;
        }
    }
}

