/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.visibility;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.bc.issue.visibility.GroupVisibility;
import com.atlassian.jira.bc.issue.visibility.InvalidVisibility;
import com.atlassian.jira.bc.issue.visibility.PublicVisibility;
import com.atlassian.jira.bc.issue.visibility.RoleVisibility;
import com.atlassian.jira.bc.issue.visibility.Visibility;
import com.atlassian.jira.issue.fields.rest.json.beans.VisibilityJsonBean;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

@PublicApi
public class Visibilities {
    private Visibilities() {
    }

    public static Visibility groupVisibility(String groupLevel) {
        return new GroupVisibility(groupLevel);
    }

    public static Visibility roleVisibility(long roleId) {
        return new RoleVisibility(roleId);
    }

    public static Visibility publicVisibility() {
        return PublicVisibility.INSTANCE;
    }

    public static Visibility fromVisibilityBean(VisibilityJsonBean visibilityBean, ProjectRoleManager projectRoleManager) {
        if (visibilityBean == null) {
            return PublicVisibility.INSTANCE;
        }
        if (visibilityBean.getType() == VisibilityJsonBean.VisibilityType.group) {
            return new GroupVisibility(visibilityBean.getValue());
        }
        if (visibilityBean.getType() == VisibilityJsonBean.VisibilityType.role) {
            return Visibilities.fromRoleLevel(visibilityBean.getValue(), projectRoleManager);
        }
        return PublicVisibility.INSTANCE;
    }

    public static Visibility fromGroupAndRoleId(@Nullable String groupLevel, @Nullable Long roleLevelId) {
        boolean roleLevelIdBlank = roleLevelId == null;
        boolean groupLevelBlank = StringUtils.isBlank((CharSequence)groupLevel);
        if (groupLevelBlank && roleLevelIdBlank) {
            return PublicVisibility.INSTANCE;
        }
        if (!groupLevelBlank && !roleLevelIdBlank) {
            return new InvalidVisibility("service.error.visibility");
        }
        if (!groupLevelBlank) {
            return new GroupVisibility(groupLevel);
        }
        return new RoleVisibility(roleLevelId);
    }

    public static Visibility fromGroupAndStrRoleId(@Nullable String groupLevel, @Nullable String roleLevelId) {
        try {
            return Visibilities.fromGroupAndRoleId(groupLevel, StringUtils.isNotBlank((CharSequence)roleLevelId) ? new Long(roleLevelId) : null);
        }
        catch (NumberFormatException e) {
            return new InvalidVisibility("service.error.roleidnotnumber");
        }
    }

    public static Visibility fromGroupAndStrRoleId(boolean levelPresent, @Nullable String groupLevel, @Nullable String roleLevelId) {
        if (levelPresent) {
            return Visibilities.fromGroupAndStrRoleId(groupLevel, roleLevelId);
        }
        return new InvalidVisibility("service.error.visibility.notavailable");
    }

    private static Visibility fromRoleLevel(String roleName, ProjectRoleManager projectRoleManager) {
        ProjectRole projectRole = projectRoleManager.getProjectRole(roleName);
        if (projectRole == null) {
            return new InvalidVisibility("service.error.roledoesnotexist", roleName);
        }
        return new RoleVisibility(projectRole.getId());
    }
}

