/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.issue.customfields.converters.DoubleConverter;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.AbstractNumberOperatorQueryFactory;
import com.atlassian.jira.jql.query.OperatorSpecificQueryFactory;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.query.RangeQueryFactory;
import com.atlassian.jira.lucenelegacy.NumericUtils;
import com.atlassian.query.operator.Operator;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class NumberRelationalQueryFactory
extends AbstractNumberOperatorQueryFactory
implements OperatorSpecificQueryFactory {
    private static final Logger log = Logger.getLogger(NumberRelationalQueryFactory.class);
    private static final RangeQueryFactory<String> RANGE_QUERY_FACTORY = RangeQueryFactory.stringRangeQueryFactory();
    private final Double emptyIndexValue;

    public NumberRelationalQueryFactory(DoubleConverter doubleConverter) {
        this(doubleConverter, null);
    }

    public NumberRelationalQueryFactory(DoubleConverter doubleConverter, Double emptyIndexValue) {
        super(doubleConverter);
        this.emptyIndexValue = emptyIndexValue;
    }

    @Override
    public QueryFactoryResult createQueryForSingleValue(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (!this.handlesOperator(operator)) {
            log.debug((Object)String.format("ActualValueRelationalQueryFactory does not support operator '%s'.", operator.getDisplayString()));
            return QueryFactoryResult.createFalseResult();
        }
        List<Double> values = this.getIndexValues(rawValues);
        if (values.isEmpty()) {
            return QueryFactoryResult.createFalseResult();
        }
        Double value = values.get(0);
        if (value == null) {
            log.debug((Object)"Relation operators do not support empty values");
            return QueryFactoryResult.createFalseResult();
        }
        Query query = RANGE_QUERY_FACTORY.get(operator, "sort_" + fieldName, NumericUtils.doubleToPrefixCoded((double)value));
        if (this.emptyIndexValue != null) {
            BooleanQuery.Builder combined = new BooleanQuery.Builder();
            combined.add(query, BooleanClause.Occur.MUST);
            combined.add((Query)new TermQuery(new Term("sort_" + fieldName, NumericUtils.doubleToPrefixCoded((double)this.emptyIndexValue))), BooleanClause.Occur.MUST_NOT);
            query = combined.build();
        }
        return new QueryFactoryResult(query);
    }

    @Override
    public QueryFactoryResult createQueryForMultipleValues(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        log.debug((Object)"Relation operators do not support multivalue operands");
        return QueryFactoryResult.createFalseResult();
    }

    @Override
    public QueryFactoryResult createQueryForEmptyOperand(String fieldName, Operator operator) {
        log.debug((Object)"Relation operators do not support multivalue empty");
        return QueryFactoryResult.createFalseResult();
    }

    @Override
    public boolean handlesOperator(Operator operator) {
        return OperatorClasses.RELATIONAL_ONLY_OPERATORS.contains((Object)operator);
    }
}

