/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.collect;

import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Iterator;
import javax.annotation.Nonnull;

class TransformingIterator<I, E>
implements Iterator<E> {
    private final Iterator<? extends I> iterator;
    private final Function<I, E> decorator;

    TransformingIterator(@Nonnull Iterator<? extends I> iterator, @Nonnull Function<I, E> decorator) {
        this.iterator = Assertions.notNull("iterator", iterator);
        this.decorator = Assertions.notNull("decorator", decorator);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public E next() {
        return this.decorator.apply(this.iterator.next());
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }
}

