/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.changehistory.metadata;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.issue.changehistory.metadata.HistoryMetadataParticipant;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@ExperimentalApi
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public final class HistoryMetadata {
    @JsonProperty
    private String type;
    @JsonProperty
    private String description;
    @JsonProperty
    private String descriptionKey;
    @JsonProperty
    private String activityDescription;
    @JsonProperty
    private String activityDescriptionKey;
    @JsonProperty
    private String emailDescription;
    @JsonProperty
    private String emailDescriptionKey;
    @JsonProperty
    private HistoryMetadataParticipant actor;
    @JsonProperty
    private HistoryMetadataParticipant generator;
    @JsonProperty
    private HistoryMetadataParticipant cause;
    @JsonProperty
    private Map<String, String> extraData;

    private HistoryMetadata() {
    }

    private HistoryMetadata(HistoryMetadataBuilder builder) {
        this.type = builder.type;
        this.description = builder.description;
        this.descriptionKey = builder.descriptionKey;
        this.activityDescription = builder.activityDescription;
        this.activityDescriptionKey = builder.activityDescriptionKey;
        this.emailDescription = builder.emailDescription;
        this.emailDescriptionKey = builder.emailDescriptionKey;
        this.actor = builder.actor;
        this.generator = builder.generator;
        this.cause = builder.cause;
        this.extraData = builder.extraData.build();
    }

    public HistoryMetadataParticipant getActor() {
        return this.actor;
    }

    public HistoryMetadataParticipant getGenerator() {
        return this.generator;
    }

    public HistoryMetadataParticipant getCause() {
        return this.cause;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    public String getActivityDescription() {
        return this.activityDescription;
    }

    public String getActivityDescriptionKey() {
        return this.activityDescriptionKey;
    }

    public String getEmailDescription() {
        return this.emailDescription;
    }

    public String getEmailDescriptionKey() {
        return this.emailDescriptionKey;
    }

    public Map<String, String> getExtraData() {
        return this.extraData;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.actor, this.generator, this.cause, this.extraData, this.description, this.descriptionKey, this.activityDescription, this.activityDescriptionKey, this.emailDescription, this.emailDescriptionKey});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HistoryMetadata other = (HistoryMetadata)obj;
        return Objects.equal((Object)this.type, (Object)other.type) && Objects.equal((Object)this.actor, (Object)other.actor) && Objects.equal((Object)this.generator, (Object)other.generator) && Objects.equal((Object)this.cause, (Object)other.cause) && Objects.equal(this.extraData, other.extraData) && Objects.equal((Object)this.description, (Object)other.description) && Objects.equal((Object)this.descriptionKey, (Object)other.descriptionKey) && Objects.equal((Object)this.activityDescription, (Object)other.activityDescription) && Objects.equal((Object)this.activityDescriptionKey, (Object)other.activityDescriptionKey) && Objects.equal((Object)this.emailDescription, (Object)other.emailDescription) && Objects.equal((Object)this.emailDescriptionKey, (Object)other.emailDescriptionKey);
    }

    public static HistoryMetadataBuilder builder(String type) {
        return new HistoryMetadataBuilder(type);
    }

    @ExperimentalApi
    public static class HistoryMetadataBuilder {
        private String type;
        private String description;
        private String descriptionKey;
        private String activityDescription;
        private String activityDescriptionKey;
        private String emailDescription;
        private String emailDescriptionKey;
        private HistoryMetadataParticipant actor;
        private HistoryMetadataParticipant generator;
        private HistoryMetadataParticipant cause;
        private ImmutableMap.Builder<String, String> extraData = ImmutableMap.builder();

        private HistoryMetadataBuilder(String type) {
            this.type = (String)Preconditions.checkNotNull((Object)type);
        }

        public HistoryMetadataBuilder description(String description) {
            this.description = description;
            return this;
        }

        public HistoryMetadataBuilder descriptionKey(String descriptionKey) {
            this.descriptionKey = descriptionKey;
            return this;
        }

        public HistoryMetadataBuilder activityDescription(String activityDescription) {
            this.activityDescription = activityDescription;
            return this;
        }

        public HistoryMetadataBuilder activityDescriptionKey(String activityDescriptionKey) {
            this.activityDescriptionKey = activityDescriptionKey;
            return this;
        }

        public HistoryMetadataBuilder emailDescription(String emailDescription) {
            this.emailDescription = emailDescription;
            return this;
        }

        public HistoryMetadataBuilder emailDescriptionKey(String emailDescriptionKey) {
            this.emailDescriptionKey = emailDescriptionKey;
            return this;
        }

        public HistoryMetadataBuilder actor(HistoryMetadataParticipant actor) {
            this.actor = actor;
            return this;
        }

        public HistoryMetadataBuilder generator(HistoryMetadataParticipant generator) {
            this.generator = generator;
            return this;
        }

        public HistoryMetadataBuilder cause(HistoryMetadataParticipant cause) {
            this.cause = cause;
            return this;
        }

        public HistoryMetadataBuilder extraData(Map<String, String> extraData) {
            this.extraData.putAll(extraData);
            return this;
        }

        public HistoryMetadataBuilder extraData(String extraDataKey, String extraDataValue) {
            this.extraData.put((Object)extraDataKey, (Object)extraDataValue);
            return this;
        }

        public HistoryMetadata build() {
            return new HistoryMetadata(this);
        }
    }
}

