/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.concurrent.Immutable;

@Immutable
@PublicApi
public final class JiraDataTypeImpl
implements JiraDataType {
    private final Collection<Class<?>> types;
    private final Collection<String> stringTypes;

    public JiraDataTypeImpl(Class<?> type) {
        this(Collections.singleton(type));
    }

    public JiraDataTypeImpl(Collection<? extends Class<?>> types) {
        Assertions.notNull("types", types);
        Assertions.not("types", types.isEmpty());
        this.types = CollectionUtil.copyAsImmutableList(types);
        ArrayList strTypes = Lists.newArrayListWithCapacity((int)types.size());
        for (Class<?> type : types) {
            strTypes.add(type.getName());
        }
        this.stringTypes = Collections.unmodifiableCollection(strTypes);
    }

    @Override
    public Collection<String> asStrings() {
        return this.stringTypes;
    }

    @Override
    public boolean matches(JiraDataType otherType) {
        Assertions.notNull("otherType", otherType);
        Assertions.stateTrue("otherType", otherType instanceof JiraDataTypeImpl);
        JiraDataTypeImpl other = (JiraDataTypeImpl)otherType;
        if (this.types.contains(Object.class) || other.types.contains(Object.class)) {
            return true;
        }
        for (Class<?> type : this.types) {
            if (!other.types.contains(type)) continue;
            return true;
        }
        return false;
    }

    public Collection<Class<?>> getTypes() {
        return this.types;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JiraDataTypeImpl that = (JiraDataTypeImpl)o;
        return this.types.equals(that.types);
    }

    public int hashCode() {
        return this.types.hashCode();
    }
}

