/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.issue;

import com.atlassian.annotations.PublicSpi;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.issue.IssueEventListener;
import com.atlassian.jira.event.issue.IssueEventVisitor;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.util.I18nHelper;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicSpi
public abstract class AbstractIssueEventListener
implements IssueEventListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractIssueEventListener.class);

    @Override
    public void issueCreated(IssueEvent event) {
        this.handleDefaultIssueEvent(event);
    }

    @Override
    public void issueUpdated(IssueEvent event) {
        this.handleDefaultIssueEvent(event);
    }

    @Override
    public void issueAssigned(IssueEvent event) {
        this.handleDefaultIssueEvent(event);
    }

    @Override
    public void issueResolved(IssueEvent event) {
        this.handleDefaultIssueEvent(event);
    }

    @Override
    public void issueClosed(IssueEvent event) {
        this.handleDefaultIssueEvent(event);
    }

    @Override
    public void issueCommented(IssueEvent event) {
        this.handleDefaultIssueEvent(event);
    }

    public void issueCommentEdited(IssueEvent event) {
        this.handleDefaultIssueEvent(event);
    }

    public void issueCommentDeleted(IssueEvent event) {
        this.issueUpdated(event);
    }

    public void issueWorklogUpdated(IssueEvent event) {
        this.handleDefaultIssueEvent(event);
    }

    public void issueWorklogDeleted(IssueEvent event) {
        this.handleDefaultIssueEvent(event);
    }

    @Override
    public void issueReopened(IssueEvent event) {
        this.handleDefaultIssueEvent(event);
    }

    @Override
    public void issueDeleted(IssueEvent event) {
        this.handleDefaultIssueEvent(event);
    }

    @Override
    public void issueWorkLogged(IssueEvent event) {
        this.handleDefaultIssueEvent(event);
    }

    @Override
    public void issueStarted(IssueEvent event) {
        this.handleDefaultIssueEvent(event);
    }

    @Override
    public void issueStopped(IssueEvent event) {
        this.handleDefaultIssueEvent(event);
    }

    @Override
    public void issueMoved(IssueEvent event) {
        this.handleDefaultIssueEvent(event);
    }

    @Override
    public void issueGenericEvent(IssueEvent event) {
        this.handleDefaultIssueEvent(event);
    }

    protected void handleDefaultIssueEvent(IssueEvent event) {
    }

    @Override
    public void workflowEvent(final IssueEvent event) {
        Long eventTypeId;
        EventTypeManager eventTypeManager = ComponentAccessor.getEventTypeManager();
        EventType eventType = eventTypeManager.getEventType(eventTypeId = event.getEventTypeId());
        if (eventType == null) {
            log.error("Issue Event Type with ID '" + eventTypeId + "' is not recognised.");
        } else {
            event.accept(new IssueEventVisitor<Void>(){

                @Override
                public Void onIssueCreated(IssueEvent e) {
                    AbstractIssueEventListener.this.issueCreated(event);
                    return null;
                }

                @Override
                public Void onIssueUpdated(IssueEvent e) {
                    AbstractIssueEventListener.this.issueUpdated(event);
                    return null;
                }

                @Override
                public Void onIssueAssigned(IssueEvent e) {
                    AbstractIssueEventListener.this.issueAssigned(event);
                    return null;
                }

                @Override
                public Void onIssueResolved(IssueEvent e) {
                    AbstractIssueEventListener.this.issueResolved(event);
                    return null;
                }

                @Override
                public Void onIssueCommented(IssueEvent e) {
                    AbstractIssueEventListener.this.issueCommented(event);
                    return null;
                }

                @Override
                public Void onIssueCommentEdited(IssueEvent e) {
                    AbstractIssueEventListener.this.issueCommentEdited(event);
                    return null;
                }

                @Override
                public Void onIssueCommentDeleted(IssueEvent e) {
                    AbstractIssueEventListener.this.issueCommentDeleted(event);
                    return null;
                }

                @Override
                public Void onIssueClosed(IssueEvent e) {
                    AbstractIssueEventListener.this.issueClosed(event);
                    return null;
                }

                @Override
                public Void onIssueReopened(IssueEvent e) {
                    AbstractIssueEventListener.this.issueReopened(event);
                    return null;
                }

                @Override
                public Void onIssueDeleted(IssueEvent e) {
                    AbstractIssueEventListener.this.issueDeleted(event);
                    return null;
                }

                @Override
                public Void onIssueMoved(IssueEvent e) {
                    AbstractIssueEventListener.this.issueMoved(event);
                    return null;
                }

                @Override
                public Void onIssueWorkLogged(IssueEvent e) {
                    AbstractIssueEventListener.this.issueWorkLogged(event);
                    return null;
                }

                @Override
                public Void onIssueWorkStarted(IssueEvent e) {
                    AbstractIssueEventListener.this.issueStarted(event);
                    return null;
                }

                @Override
                public Void onIssueWorkStopped(IssueEvent e) {
                    AbstractIssueEventListener.this.issueStopped(event);
                    return null;
                }

                @Override
                public Void onIssueWorklogUpdated(IssueEvent e) {
                    AbstractIssueEventListener.this.issueWorklogUpdated(event);
                    return null;
                }

                @Override
                public Void onIssueWorklogDeleted(IssueEvent e) {
                    AbstractIssueEventListener.this.issueWorklogDeleted(event);
                    return null;
                }

                @Override
                public Void onIssueGenericEvent(IssueEvent e) {
                    AbstractIssueEventListener.this.issueGenericEvent(event);
                    return null;
                }

                @Override
                public Void onCustomEvent(IssueEvent e) {
                    AbstractIssueEventListener.this.customEvent(event);
                    return null;
                }
            });
        }
    }

    @Override
    public void customEvent(IssueEvent event) {
        this.handleDefaultIssueEvent(event);
    }

    public void init(Map params) {
    }

    @Override
    public String[] getAcceptedParams() {
        return new String[0];
    }

    @Override
    public boolean isInternal() {
        return false;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String getDescription() {
        return null;
    }

    protected I18nHelper getI18NBean() {
        return ComponentAccessor.getJiraAuthenticationContext().getI18nHelper();
    }
}

