/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.bc.issue.worklog.TimeTrackingConfiguration;
import com.atlassian.jira.issue.fields.rest.json.UserBeanFactory;
import com.atlassian.jira.issue.fields.rest.json.WorklogBeanFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.VisibilityJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.WorklogJsonBean;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.rest.Dates;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.net.URI;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class DefaultWorklogBeanFactory
implements WorklogBeanFactory {
    private final TimeTrackingConfiguration timeTrackingConfiguration;
    private final JiraBaseUrls jiraBaseUrls;
    private final UserBeanFactory userBeanFactory;
    private final UserManager userManager;

    public DefaultWorklogBeanFactory(TimeTrackingConfiguration timeTrackingConfiguration, JiraBaseUrls jiraBaseUrls, UserBeanFactory userBeanFactory, UserManager userManager) {
        this.timeTrackingConfiguration = timeTrackingConfiguration;
        this.jiraBaseUrls = jiraBaseUrls;
        this.userBeanFactory = userBeanFactory;
        this.userManager = userManager;
    }

    @Override
    public WorklogJsonBean createBean(Worklog worklog, ApplicationUser loggedInUser) {
        URI self = URI.create(this.worklogSelf(worklog));
        return WorklogJsonBean.build().setId(Long.toString(worklog.getId())).setIssueId(Long.toString(worklog.getIssue().getId())).setComment(worklog.getComment()).setTimeSpent(this.getTimeLoggedString(worklog.getTimeSpent())).setTimeSpentSeconds(worklog.getTimeSpent()).setCreated(Dates.asTimeString(worklog.getCreated())).setUpdated(Dates.asTimeString(worklog.getUpdated())).setStarted(Dates.asTimeString(worklog.getStartDate())).setSelf(self).setAuthor(this.getUserBean(worklog.getAuthorKey(), loggedInUser)).setUpdateAuthor(this.getUserBean(worklog.getUpdateAuthorKey(), loggedInUser)).setVisibility(this.getVisibilityBean(worklog)).build();
    }

    private String worklogSelf(Worklog worklog) {
        return this.jiraBaseUrls.restApi2BaseUrl() + "issue/" + worklog.getIssue().getId().toString() + "/worklog/" + worklog.getId().toString();
    }

    @Override
    public Iterable<WorklogJsonBean> createBeans(Iterable<Worklog> worklogs, ApplicationUser loggedInUser) {
        return Iterables.transform(worklogs, worklog -> this.createBean((Worklog)worklog, loggedInUser));
    }

    protected UserJsonBean getUserBean(String userKey, ApplicationUser loggedInUser) {
        ApplicationUser user = this.userManager.getUserByKey(userKey);
        if (user != null) {
            return this.userBeanFactory.createBean(user, loggedInUser);
        }
        if (StringUtils.isNotBlank((String)userKey)) {
            UserJsonBean userJsonBean = new UserJsonBean();
            userJsonBean.setName(userKey);
            return userJsonBean;
        }
        return null;
    }

    @Nullable
    private VisibilityJsonBean getVisibilityBean(Worklog worklog) {
        String groupLevel = worklog.getGroupLevel();
        ProjectRole roleLevel = worklog.getRoleLevel();
        if (groupLevel != null) {
            return new VisibilityJsonBean(VisibilityJsonBean.VisibilityType.group, groupLevel);
        }
        if (roleLevel != null) {
            return new VisibilityJsonBean(VisibilityJsonBean.VisibilityType.role, roleLevel.getName());
        }
        return null;
    }

    private String getTimeLoggedString(long timeSpent) {
        BigDecimal hoursPerDay = this.timeTrackingConfiguration.getHoursPerDay();
        BigDecimal daysPerWeek = this.timeTrackingConfiguration.getDaysPerWeek();
        BigDecimal secondsPerHour = BigDecimal.valueOf(DateUtils.Duration.HOUR.getSeconds());
        long secondsPerDay = hoursPerDay.multiply(secondsPerHour).longValueExact();
        long secondsPerWeek = daysPerWeek.multiply(hoursPerDay).multiply(secondsPerHour).longValueExact();
        return DateUtils.getDurationStringSeconds((long)timeSpent, (long)secondsPerDay, (long)secondsPerWeek);
    }
}

