/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.summary;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.index.summary.IndexReplicationQueueEntry;
import java.util.Optional;

@ExperimentalApi
public class IndexReplicationQueueSummary {
    private final String sendingNodeId;
    private final IndexReplicationQueueEntry lastConsumedOperation;
    private final IndexReplicationQueueEntry lastOperationInQueue;
    private final long queueSize;

    public IndexReplicationQueueSummary(String sendingNodeId, IndexReplicationQueueEntry lastConsumedOperation, IndexReplicationQueueEntry lastOperationInQueue, Long queueSize) {
        this.sendingNodeId = sendingNodeId;
        this.lastConsumedOperation = lastConsumedOperation;
        this.lastOperationInQueue = lastOperationInQueue;
        this.queueSize = queueSize;
    }

    public String getSendingNodeId() {
        return this.sendingNodeId;
    }

    public Optional<IndexReplicationQueueEntry> getLastConsumedOperation() {
        return Optional.ofNullable(this.lastConsumedOperation);
    }

    public Optional<IndexReplicationQueueEntry> getLastOperationInQueue() {
        return Optional.ofNullable(this.lastOperationInQueue);
    }

    public long getQueueSize() {
        return this.queueSize;
    }
}

