/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.operand.FunctionOperand;
import java.util.List;

public class NumberOfArgumentsValidator {
    private final int minExpected;
    private final int maxExpected;
    private final I18nHelper i18n;

    public NumberOfArgumentsValidator(int expected, I18nHelper i18nHelper) {
        this(expected, expected, i18nHelper);
    }

    public NumberOfArgumentsValidator(int minExpected, int maxExpected, I18nHelper i18nHelper) {
        if (minExpected < 0 || maxExpected < 0) {
            throw new IllegalArgumentException("expected args must not be negative");
        }
        if (minExpected > maxExpected) {
            throw new IllegalArgumentException("Minimum number of args must be <= maximum number of args");
        }
        this.minExpected = minExpected;
        this.maxExpected = maxExpected;
        this.i18n = Assertions.notNull("i18nHelper", i18nHelper);
    }

    public MessageSet validate(FunctionOperand operand) {
        List<String> args = operand.getArgs();
        String name = operand.getName();
        MessageSetImpl messages = new MessageSetImpl();
        if (this.minExpected == this.maxExpected && args.size() != this.minExpected) {
            messages.addErrorMessage(this.i18n.getText("jira.jql.function.arg.incorrect.exact", name, this.minExpected + "", args.size() + ""));
        } else if (this.minExpected > args.size() || this.maxExpected < args.size()) {
            messages.addErrorMessage(this.i18n.getText("jira.jql.function.arg.incorrect.range", name, this.minExpected + "", this.maxExpected + "", args.size() + ""));
        }
        return messages;
    }
}

