/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.util.JiraUrlCodec;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.codehaus.jackson.annotate.JsonProperty;

public class ResolutionJsonBean {
    @JsonProperty
    private String self;
    @JsonProperty
    private String id;
    @JsonProperty
    private String description;
    @JsonProperty
    private String iconUrl;
    @JsonProperty
    private String name;

    public static Collection<ResolutionJsonBean> shortBeans(Collection<Resolution> resolutions, JiraBaseUrls urls) {
        ArrayList result = Lists.newArrayListWithCapacity((int)resolutions.size());
        for (Resolution from : resolutions) {
            result.add(ResolutionJsonBean.shortBean(from, urls));
        }
        return result;
    }

    public static ResolutionJsonBean shortBean(Resolution resolution, JiraBaseUrls urls) {
        if (resolution == null) {
            return null;
        }
        ResolutionJsonBean bean = new ResolutionJsonBean();
        bean.self = urls.restApi2BaseUrl() + "resolution/" + JiraUrlCodec.encode(resolution.getId().toString());
        bean.id = resolution.getId();
        bean.name = resolution.getNameTranslation();
        bean.description = resolution.getDescTranslation();
        return bean;
    }
}

