/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import java.net.URI;

public class UriMatcher {
    public static boolean isBaseEqual(URI baseUri, URI testUri) {
        baseUri = baseUri.normalize();
        testUri = testUri.normalize();
        boolean schemeEqual = baseUri.getScheme().equalsIgnoreCase(testUri.getScheme());
        boolean hostEqual = baseUri.getHost().equalsIgnoreCase(testUri.getHost());
        boolean portEqual = UriMatcher.normalizedPort(baseUri) == UriMatcher.normalizedPort(testUri);
        boolean pathEqual = testUri.getPath().startsWith(baseUri.getPath());
        return schemeEqual && hostEqual && portEqual && pathEqual;
    }

    private static int normalizedPort(URI uri) {
        if (uri.getPort() == -1) {
            if ("http".equalsIgnoreCase(uri.getScheme())) {
                return 80;
            }
            if ("https".equalsIgnoreCase(uri.getScheme())) {
                return 443;
            }
        }
        return uri.getPort();
    }
}

