/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.io;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.util.Consumer;
import java.io.InputStream;
import java.util.Optional;
import javax.annotation.Nonnull;

@ExperimentalApi
public class MediaConsumer {
    private final Optional<Consumer<String>> contentTypeConsumer;
    private final Consumer<InputStream> dataConsumer;

    public MediaConsumer(@Nonnull Consumer<String> contentTypeConsumer, @Nonnull Consumer<InputStream> dataConsumer) {
        this.contentTypeConsumer = Optional.of(contentTypeConsumer);
        this.dataConsumer = dataConsumer;
    }

    public MediaConsumer(Consumer<InputStream> dataConsumer) {
        this.contentTypeConsumer = Optional.empty();
        this.dataConsumer = dataConsumer;
    }

    public void consumeData(InputStream inputStream) {
        this.dataConsumer.consume(inputStream);
    }

    public void consumeContentType(String contentType) {
        this.contentTypeConsumer.orElse(this::noOpConsume).consume(contentType);
    }

    private void noOpConsume(String contentType) {
    }
}

