/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.annotations.PublicApi;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

@PublicApi
public final class OrderByRequest<T> {
    private final T field;
    private final Order order;

    public OrderByRequest(T field, Order order) {
        this.field = Preconditions.checkNotNull(field);
        this.order = (Order)((Object)Preconditions.checkNotNull((Object)((Object)order)));
    }

    public T getField() {
        return this.field;
    }

    public Order getOrder() {
        return this.order;
    }

    public static <T extends Enum<T>> OrderByRequest<T> asc(T field) {
        return new OrderByRequest<T>(field, Order.ASC);
    }

    public static <T extends Enum<T>> OrderByRequest<T> desc(T field) {
        return new OrderByRequest<T>(field, Order.DESC);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderByRequest that = (OrderByRequest)o;
        return Objects.equal(this.field, that.field) && Objects.equal((Object)((Object)this.order), (Object)((Object)that.order));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.field, this.order});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("field", this.field).add("type", (Object)this.order).toString();
    }

    public static enum Order {
        ASC,
        DESC;

    }
}

