/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.search;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.List;

@PublicApi
public class SharedEntitySearchResult<E extends SharedEntity>
implements EnclosedIterable<E> {
    private final EnclosedIterable<E> results;
    private final boolean hasNext;
    private final int totalResultCount;

    public SharedEntitySearchResult(EnclosedIterable<E> results, boolean hasNext, int totalResultCount) {
        this.results = Assertions.notNull("results", results);
        this.hasNext = hasNext;
        this.totalResultCount = totalResultCount;
    }

    public List<E> getResults() {
        return new EnclosedIterable.ListResolver<E>().get(this.results);
    }

    public boolean hasMoreResults() {
        return this.hasNext;
    }

    public int getTotalResultCount() {
        return this.totalResultCount;
    }

    @Override
    public final void foreach(Consumer<E> sink) {
        this.results.foreach(sink);
    }

    @Override
    public int size() {
        return this.results.size();
    }

    @Override
    public boolean isEmpty() {
        return this.results.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SharedEntitySearchResult)) {
            return false;
        }
        SharedEntitySearchResult that = (SharedEntitySearchResult)o;
        if (this.totalResultCount != that.totalResultCount) {
            return false;
        }
        List resultsList = new EnclosedIterable.ListResolver<E>().get(this.results);
        List otherResultsList = new EnclosedIterable.ListResolver<E>().get(that.results);
        return resultsList.equals(otherResultsList);
    }

    public int hashCode() {
        List resultsList = new EnclosedIterable.ListResolver<E>().get(this.results);
        int result = resultsList.hashCode();
        result = 31 * result + this.totalResultCount;
        return result;
    }
}

