/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl;

import com.atlassian.annotations.PublicSpi;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.customfields.TextCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.AbstractSingleFieldType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.TextFieldCharacterLengthValidator;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareCustomFieldType;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Deprecated
@PublicSpi
public abstract class StringCFType
extends AbstractSingleFieldType
implements RestAwareCustomFieldType,
TextCustomFieldType {
    private final TextFieldCharacterLengthValidator textFieldCharacterLengthValidator;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Deprecated
    public StringCFType(CustomFieldValuePersister customFieldValuePersister, GenericConfigManager genericConfigManager) {
        this(customFieldValuePersister, genericConfigManager, ComponentAccessor.getComponent(TextFieldCharacterLengthValidator.class), ComponentAccessor.getJiraAuthenticationContext());
    }

    public StringCFType(CustomFieldValuePersister customFieldValuePersister, GenericConfigManager genericConfigManager, TextFieldCharacterLengthValidator textFieldCharacterLengthValidator, JiraAuthenticationContext jiraAuthenticationContext) {
        super(customFieldValuePersister, genericConfigManager);
        this.textFieldCharacterLengthValidator = textFieldCharacterLengthValidator;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    protected Object getDbValueFromObject(Object customFieldObject) {
        return this.getStringFromSingularObject(customFieldObject);
    }

    protected Object getObjectFromDbValue(@Nonnull Object databaseValue) throws FieldValidationException {
        return this.getSingularObjectFromString((String)databaseValue);
    }

    @Override
    public String getValueFromCustomFieldParams(CustomFieldParams relevantParams) throws FieldValidationException {
        String value = (String)super.getValueFromCustomFieldParams(relevantParams);
        if (this.textFieldCharacterLengthValidator.isTextTooLong(value)) {
            I18nHelper i18nBean = this.jiraAuthenticationContext.getI18nHelper();
            long maximumNumberOfCharacters = this.textFieldCharacterLengthValidator.getMaximumNumberOfCharacters();
            throw new FieldValidationException(i18nBean.getText("field.error.text.toolong", maximumNumberOfCharacters));
        }
        return value;
    }

    @Override
    public Object accept(AbstractCustomFieldType.VisitorBase visitor) {
        if (visitor instanceof Visitor) {
            return ((Visitor)visitor).visitString(this);
        }
        return super.accept(visitor);
    }

    @Override
    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        return new FieldTypeInfo(null, null);
    }

    @Override
    public JsonType getJsonSchema(CustomField customField) {
        return JsonTypeBuilder.custom("string", this.getKey(), customField.getIdAsLong());
    }

    @Override
    public FieldJsonRepresentation getJsonFromIssue(CustomField field, Issue issue, boolean renderedVersionRequested, @Nullable FieldLayoutItem fieldLayoutItem) {
        Object value = this.getValueFromIssue(field, issue);
        FieldJsonRepresentation bean = new FieldJsonRepresentation(new JsonData(value));
        if (field.isRenderable() && renderedVersionRequested && fieldLayoutItem != null) {
            String content = ComponentAccessor.getComponent(RendererManager.class).getRenderedContent(fieldLayoutItem, issue);
            bean.setRenderedData(new JsonData(content));
        }
        return bean;
    }

    public static interface Visitor<T>
    extends AbstractCustomFieldType.VisitorBase<T> {
        public T visitString(StringCFType var1);
    }
}

