/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.export;

import com.atlassian.jira.issue.export.FieldExportPart;
import com.atlassian.jira.issue.export.FieldExportParts;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class FieldExportPartsBuilder {
    private final Set<String> ids = Sets.newHashSet();
    private final List<FieldExportPart> items = Lists.newArrayList();

    public FieldExportPartsBuilder addItem(String id, String label, Stream<String> values) {
        if (this.ids.contains(id)) {
            throw new IllegalStateException("Id '" + id + "' has already been set previously, use a different id.");
        }
        this.items.add(new FieldExportPart(id, label, values));
        this.ids.add(id);
        return this;
    }

    public FieldExportPartsBuilder addItem(String id, String label, String value) {
        return this.addItem(id, label, Stream.of(value));
    }

    public FieldExportParts build() {
        return new FieldExportParts(this.items);
    }

    public static FieldExportParts buildSinglePartRepresentation(String id, String label, @Nullable String value) {
        if (value == null) {
            return FieldExportPartsBuilder.buildSinglePartRepresentation(id, label, Stream.of(""));
        }
        return FieldExportPartsBuilder.buildSinglePartRepresentation(id, label, Stream.of(value));
    }

    public static FieldExportParts buildSinglePartRepresentation(String id, String label, Stream<String> values) {
        FieldExportPart item = new FieldExportPart(id, label, values);
        return new FieldExportParts((List<FieldExportPart>)ImmutableList.of((Object)item));
    }
}

