/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.conditions.cache;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.plugin.webfragment.conditions.cache.ConditionCacheKey;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.google.common.base.Supplier;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;

@ExperimentalApi
public class RequestCachingConditionHelper {
    public static boolean cacheConditionResultInRequest(@Nonnull ConditionCacheKey cacheKey, @Nonnull Supplier<Boolean> supplier) {
        HttpServletRequest request = ExecutingHttpRequest.get();
        if (request == null) {
            return (Boolean)supplier.get();
        }
        Object cachedConditionResult = request.getAttribute(cacheKey.toString());
        if (cachedConditionResult == null || !(cachedConditionResult instanceof Boolean)) {
            try {
                boolean conditionResult = (Boolean)supplier.get();
                request.setAttribute(cacheKey.toString(), (Object)conditionResult);
                cachedConditionResult = conditionResult;
            }
            catch (Exception e) {
                return false;
            }
        }
        return (Boolean)cachedConditionResult;
    }
}

